import '../shared/router_gage.dart';

enum DirectionalScreenName {
  flashSale,
  searchProduct,
  setting,
  cashBackPointPartnerDetail,
  notifications,
  notification,
  appScreen,
  website,
  voucher,
  productOwnVoucher,
  myMobileCard,
  brand,
  transaction,
  link,
  viewDeepLink,
  viewDeepLinkInApp,
  viewGift,
  feedback,
  dailyCheckin,
  dailyCheckinScreen,
  inputReferralCode,
  myPurchaseItems,
  myPurchaseItemsWaitingList,
  achievement,
  productVoucherLike,
  productMobileCard,
  workerProfile,
  customerInviteFriend,
  customerTransferPoint,
  customerReviewApp,
  preferentialHotList,
  pointHistory,
  refundHistory,
  home,
  pointBack,
  brandList,
  news,
  brandLike,
  productVoucher,
  memberShip,
  ranking,
  mobileTopup,
  mobileTopupData,
  topup,
  register,
  gifts,
  viewSMS,
  walkingCampaign,
  applicationSetting,
  customerSupport,
  historyInvitedFriend,
  gameWorldCup2022,
  rateStorePopup,
  simService,
  vietlott,
  shoppingOnline,
  electricBill,
  partnerRedirect,
  brandOffline,
  pipiScreen,
  campaignSevenDayScreen,
  surveyCampaign,
  inviteFriend,
  viewVoucherWithCountTime,
  viewAllVoucher,
  popViewController,
  finishScreen,
  screenAddInvitationCode,
  luckyMoney,
  termPolicyDeleteAccount,
  privacyPolicy,
  termsOfUse,
  termPolicyDecree13,
  bankAccountManager,
  familyMedon,
  familyMedonDetailCard,
  familyHealthBook,
  gameCenter,
  vnTraPackage,
  myVnTraPackage,
  detailTrafficService,
  makeDirectionScreen,
  webviewFullScreen,
  gamesBundle,
  gameCardDetail,
  newInviteFriend,
  inviteFriendApply,
  personal,
  voucherTab,
  introduction,
  listPaymentOfElectric,
  favorite,
  pointHunting,
  orderMenu,
  unknown,
  transactionHistories,
  qrCode,
  linkMBPAccount,
}

extension DirectionalScreenNameExtension on DirectionalScreenName {
  String get rawValue {
    switch (this) {
      case DirectionalScreenName.flashSale:
        return "APP_SCREEN_FLASH_SALE";
      case DirectionalScreenName.searchProduct:
        return "APP_SCREEN_SEARCH_PRODUCTS";
      case DirectionalScreenName.setting:
        return "APP_SCREEN_SETTING";
      case DirectionalScreenName.cashBackPointPartnerDetail:
        return "APP_SCREEN_CASHBACK_PARTNER_DETAIL";
      case DirectionalScreenName.notifications:
        return "APP_SCREEN_NOTIFICATIONS";
      case DirectionalScreenName.notification:
        return "NOTIFICATION_DETAIL";
      case DirectionalScreenName.appScreen:
        return "VIEW_APP_SCREEN";
      case DirectionalScreenName.website:
        return "VIEW_WEBSITE_PAGE";
      case DirectionalScreenName.voucher:
        return "VIEW_PRODUCT_VOUCHER";
      case DirectionalScreenName.productOwnVoucher:
        return "VIEW_PRODUCT_OWN_VOUCHER";
      case DirectionalScreenName.myMobileCard:
        return "VIEW_MY_MOBILE_CARD";
      case DirectionalScreenName.brand:
        return "VIEW_BRAND";
      case DirectionalScreenName.transaction:
        return "VIEW_TRANSACTION_REQUEST";
      case DirectionalScreenName.link:
        return "VIEW_LINK";
      case DirectionalScreenName.viewDeepLink:
        return "VIEW_DEEP_LINK";
      case DirectionalScreenName.viewDeepLinkInApp:
        return "VIEW_DEEP_LINK_INAPP";
      case DirectionalScreenName.viewGift:
        return "VIEW_GIFT";
      case DirectionalScreenName.feedback:
        return "FEEDBACK";
      case DirectionalScreenName.dailyCheckin:
        return "DAILY_CHECKIN";
      case DirectionalScreenName.dailyCheckinScreen:
        return "APP_SCREEN_CUSTOMER_DAILY_CHECKIN";
      case DirectionalScreenName.inputReferralCode:
        return "INPUT_REFERRAL_CODE";
      case DirectionalScreenName.myPurchaseItems:
        return "APP_SCREEN_MY_PURCHASE_ITEMS";
      case DirectionalScreenName.myPurchaseItemsWaitingList:
        return "APP_SCREEN_MY_PURCHASE_ITEMS-WAITING_LIST";
      case DirectionalScreenName.achievement:
        return "APP_SCREEN_ACHIEVEMENT";
      case DirectionalScreenName.productVoucherLike:
        return "APP_SCREEN_PRODUCT_VOUCHER_LIKES";
      case DirectionalScreenName.productMobileCard:
        return "APP_SCREEN_PRODUCT_MOBILE_CARD";
      case DirectionalScreenName.workerProfile:
        return "APP_SCREEN_WORKER_PROFILE";
      case DirectionalScreenName.customerInviteFriend:
        return "APP_SCREEN_CUSTOMER_INVITE_FRIEND";
      case DirectionalScreenName.customerTransferPoint:
        return "APP_SCREEN_CUSTOMER_TRANSFERT_POINT";
      case DirectionalScreenName.customerReviewApp:
        return "APP_SCREEN_CUSTOMER_REVIEW_APP";
      case DirectionalScreenName.preferentialHotList:
        return "APP_SCREEN_PREFERENTIAL_HOT_LIST";
      case DirectionalScreenName.pointHistory:
        return "APP_SCREEN_POINT_HISTORY";
      case DirectionalScreenName.refundHistory:
        return "APP_SCREEN_REFUND_HISTORY";
      case DirectionalScreenName.home:
        return "APP_SCREEN_HOME";
      case DirectionalScreenName.pointBack:
        return "APP_SCREEN_POINTBACK";
      case DirectionalScreenName.brandList:
        return "APP_SCREEN_BRAND_LIST";
      case DirectionalScreenName.news:
        return "APP_SCREEN_NEWS";
      case DirectionalScreenName.brandLike:
        return "APP_SCREEN_BRAND_LIKES";
      case DirectionalScreenName.productVoucher:
        return "APP_SCREEN_PRODUCT_VOUCHER";
      case DirectionalScreenName.memberShip:
        return "APP_SCREEN_MEMBERSHIP_LEVEL";
      case DirectionalScreenName.ranking:
        return "APP_SCREEN_RANKING_PROGRAM";
      case DirectionalScreenName.mobileTopup:
        return "APP_SCREEN_PRODUCT_MOBILE_TOPUP";
      case DirectionalScreenName.mobileTopupData:
        return "APP_SCREEN_MOBILE_TOPUP_DATA";
      case DirectionalScreenName.topup:
        return "APP_SCREEN_TOPUP";
      case DirectionalScreenName.register:
        return "APP_SCREEN_REGISTER";
      case DirectionalScreenName.gifts:
        return "APP_SCREEN_GIFTS";
      case DirectionalScreenName.viewSMS:
        return "VIEW_SMS";
      case DirectionalScreenName.walkingCampaign:
        return "APP_SCREEN_CAMPAIGN_WALKING";
      case DirectionalScreenName.applicationSetting:
        return "APPLICATION_SETTING";
      case DirectionalScreenName.customerSupport:
        return "APP_SCREEN_CUSTOMER_FEEDBACK";
      case DirectionalScreenName.historyInvitedFriend:
        return "APP_SCREEN_HISTORY_INVITED";
      case DirectionalScreenName.gameWorldCup2022:
        return "APP_SCREEN_GAME_WORLDCUP";
      case DirectionalScreenName.rateStorePopup:
        return "OPEN_RATE_STORE";
      case DirectionalScreenName.simService:
        return "APP_SCREEN_SIM_SERVICE";
      case DirectionalScreenName.vietlott:
        return "APP_SCREEN_VIETLOTT";
      case DirectionalScreenName.shoppingOnline:
        return "APP_SCREEN_SHOPPING_ONLINE";
      case DirectionalScreenName.electricBill:
        return "APP_SCREEN_ELECTRIC_BILL";
      case DirectionalScreenName.partnerRedirect:
        return "PARTNER_REDIRECT";
      case DirectionalScreenName.brandOffline:
        return "VIEW_BRAND_TAB_VOUCHER_OFFLINE";
      case DirectionalScreenName.pipiScreen:
        return "APP_SCREEN_PIPI";
      case DirectionalScreenName.campaignSevenDayScreen:
        return "APP_SCREEN_CAMPAIGN_TASKS";
      case DirectionalScreenName.surveyCampaign:
        return "APP_SCREEN_SURVERY_APP";
      case DirectionalScreenName.inviteFriend:
        return "APP_SCREEN_INVITE_FRIEND";
      case DirectionalScreenName.viewVoucherWithCountTime:
        return "APP_SCREEN_VIEW_VOUCHER";
      case DirectionalScreenName.viewAllVoucher:
        return "APP_SCREEN_ALL_VOUCHER";
      case DirectionalScreenName.popViewController:
        return "POP_VIEW_CONTROLLER";
      case DirectionalScreenName.finishScreen:
        return "FINISHED_SCREEN";
      case DirectionalScreenName.screenAddInvitationCode:
        return "APP_SCREEN_ADD_INVITATION_CODE";
      case DirectionalScreenName.luckyMoney:
        return "APP_SCREEN_LUCKY_MONEY";
      case DirectionalScreenName.termPolicyDeleteAccount:
        return "TERM_POLICY_DELETE_ACCOUNT";
      case DirectionalScreenName.privacyPolicy:
        return "APP_SCREEN_PRIVACY_POLICY";
      case DirectionalScreenName.termsOfUse:
        return "APP_SCREEN_TERMS_OF_USE";
      case DirectionalScreenName.termPolicyDecree13:
        return "TERM_POLICY_DECREE_13";
      case DirectionalScreenName.bankAccountManager:
        return "BANK_ACCOUNT_MANAGER";
      case DirectionalScreenName.familyMedon:
        return "APP_SCREEN_CARD_FAMILY_MEDON";
      case DirectionalScreenName.familyMedonDetailCard:
        return "MEDON_DETAIL_CARD";
      case DirectionalScreenName.familyHealthBook:
        return "FAMILY_HEALTH_BOOK";
      case DirectionalScreenName.gameCenter:
        return "VPLAY_GAME_CENTER";
      case DirectionalScreenName.vnTraPackage:
        return "APP_SCREEN_VNTRA_PACKAGE";
      case DirectionalScreenName.myVnTraPackage:
        return "APP_SCREEN_MY_VNTRA_PACKAGE";
      case DirectionalScreenName.detailTrafficService:
        return "DETAIL_TRAFFIC_SERVICES";
      case DirectionalScreenName.makeDirectionScreen:
        return "GET_DIRECTION_SCREEN";
      case DirectionalScreenName.webviewFullScreen:
        return "APP_VIEW_WEBVIEW_FULL_SCREEN";
      case DirectionalScreenName.gamesBundle:
        return "APP_SCREEN_GAME_BUNDLE";
      case DirectionalScreenName.gameCardDetail:
        return "APP_SCREEN_GAME_CARD_DETAIL";
      case DirectionalScreenName.newInviteFriend:
        return "APP_SCREEN_INVITE_FRIEND_MANAGER";
      case DirectionalScreenName.inviteFriendApply:
        return "APP_SCREEN_INVITE_FRIEND_APPLY";
      case DirectionalScreenName.personal:
        return "APP_SCREEN_PERSONAL";
      case DirectionalScreenName.voucherTab:
        return "APP_SCREEN_VOUCHER_TAB";
      case DirectionalScreenName.introduction:
        return "APP_SCREEN_INTRODUCTION";
      case DirectionalScreenName.listPaymentOfElectric:
        return "APP_SCREEN_LIST_PAYMENT_OF_ELECTRIC";
      case DirectionalScreenName.favorite:
        return "APP_SCREEN_CATEGORY_TAB_FAVORITE";
      case DirectionalScreenName.pointHunting:
        return "APP_SCREEN_POINT_HUNTING";
      case DirectionalScreenName.unknown:
        return "UNKNOWN";
      case DirectionalScreenName.orderMenu:
        return "APP_SCREEN_ORDER_MENU";
      case DirectionalScreenName.transactionHistories:
        return "APP_SCREEN_TRANSACTION_HISTORIES";
      case DirectionalScreenName.qrCode:
        return "APP_SCREEN_QR_CODE";
      case DirectionalScreenName.linkMBPAccount:
        return "APP_SCREEN_LINK_MBP_ACCOUNT";
    }
  }

  static DirectionalScreenName fromRawValue(String rawValue) {
    return DirectionalScreenName.values.firstWhere(
      (e) => e.rawValue == rawValue.trim(),
      orElse: () => DirectionalScreenName.unknown,
    );
  }

  static fromString(String s) {}
}
