// Web-specific implementations for x-app-sdk
import 'package:flutter/foundation.dart';
import 'x_app_sdk_service.dart';

/// Web-specific helper functions for x-app-sdk integration

/// Initialize x-app-sdk service
Future<void> webInitializeXAppSDK() async {
  try {
    await XAppSDKService().initialize();
  } catch (e) {
    print('❌ Error initializing x-app-sdk: $e');
  }
}

/// Get token from x-app-sdk
Future<String?> webGetToken() async {
  try {
    return await XAppSDKService().getToken();
  } catch (e) {
    print('❌ Error getting token: $e');
    return null;
  }
}

/// Close app and return to Super App
Future<bool> webCloseApp([Map<String, dynamic>? data]) async {
  try {
    return await XAppSDKService().closeApp(data);
  } catch (e) {
    print('❌ Error closing app: $e');
    return false;
  }
}

/// Check if x-app-sdk is initialized
bool webIsSDKInitialized() {
  try {
    return XAppSDKService().isInitialized;
  } catch (e) {
    print('❌ Error checking SDK status: $e');
    return false;
  }
}

/// Get cached token
String? webGetCachedToken() {
  try {
    return XAppSDKService().cachedToken;
  } catch (e) {
    print('❌ Error getting cached token: $e');
    return null;
  }
}

/// Get last error message
String? webGetLastError() {
  try {
    return XAppSDKService().lastError;
  } catch (e) {
    print('❌ Error getting last error: $e');
    return null;
  }
}

/// Clear token cache
void webClearTokenCache() {
  try {
    XAppSDKService().clearToken();
  } catch (e) {
    print('❌ Error clearing token cache: $e');
  }
}

/// Reset SDK service
void webResetSDK() {
  try {
    XAppSDKService().reset();
  } catch (e) {
    print('❌ Error resetting SDK: $e');
  }
}

Future<dynamic> webConfigUIApp(Map<String, dynamic> config) async {
  try {
    return await XAppSDKService().configUIApp(config);
  } catch (e) {
    print('❌ Error configuring UI app: $e');
    return null;
  }
}

Future<dynamic> webCallPhone(String phoneNumber) async {
  try {
    return await XAppSDKService().callPhone(phoneNumber);
  } catch (e) {
    print('❌ Error calling phone: $e');
    return null;
  }
}

Future<dynamic> webCall(String phoneNumber) => webCallPhone(phoneNumber);

Future<dynamic> webSendSms(String phoneNumber) async {
  try {
    return await XAppSDKService().sendSms(phoneNumber);
  } catch (e) {
    print('❌ Error sending SMS: $e');
    return null;
  }
}

Future<dynamic> webSms(String phoneNumber) => webSendSms(phoneNumber);

Future<dynamic> webVibrate() async {
  try {
    return await XAppSDKService().vibrate();
  } catch (e) {
    print('❌ Error vibrating device: $e');
    return null;
  }
}

Future<dynamic> webCurrentLocation() async {
  try {
    return await XAppSDKService().currentLocation();
  } catch (e) {
    print('❌ Error getting current location: $e');
    return null;
  }
}

Future<dynamic> webRequestLocationPermission() async {
  try {
    return await XAppSDKService().requestLocationPermission();
  } catch (e) {
    print('❌ Error requesting location permission: $e');
    return null;
  }
}

Future<dynamic> webOpenPickerImage(dynamic type) async {
  try {
    return await XAppSDKService().openPickerImage(type);
  } catch (e) {
    print('❌ Error opening image picker: $e');
    return null;
  }
}

Future<dynamic> webOpenPickerFile([dynamic options]) async {
  try {
    return await XAppSDKService().openPickerFile(options);
  } catch (e) {
    print('❌ Error opening file picker: $e');
    return null;
  }
}

Future<dynamic> webPaymentRequest(Map<String, dynamic> payload) async {
  try {
    return await XAppSDKService().paymentRequest(payload);
  } catch (e) {
    print('❌ Error creating payment request: $e');
    return null;
  }
}

Future<VoidCallback?> webListenNotificationEvent(
  ValueChanged<dynamic> onEvent,
) async {
  try {
    return await XAppSDKService().listenNotificationEvent(onEvent);
  } catch (e) {
    print('❌ Error registering notification listener: $e');
    return null;
  }
}

Future<VoidCallback?> webListenPaymentEvent(
  ValueChanged<dynamic> onEvent,
) async {
  try {
    return await XAppSDKService().listenPaymentEvent(onEvent);
  } catch (e) {
    print('❌ Error registering payment listener: $e');
    return null;
  }
}

Future<dynamic> webPermissionsRequest(dynamic type) async {
  try {
    return await XAppSDKService().permissionsRequest(type);
  } catch (e) {
    print('❌ Error requesting permission: $e');
    return null;
  }
}

Future<dynamic> webPremissionsRequest(dynamic type) =>
    webPermissionsRequest(type);

Future<dynamic> webSaveStore(dynamic data) async {
  try {
    return await XAppSDKService().saveStore(data);
  } catch (e) {
    print('❌ Error saving store data: $e');
    return null;
  }
}

Future<dynamic> webGetStore() async {
  try {
    return await XAppSDKService().getStore();
  } catch (e) {
    print('❌ Error getting store data: $e');
    return null;
  }
}

Future<dynamic> webClearStore() async {
  try {
    return await XAppSDKService().clearStore();
  } catch (e) {
    print('❌ Error clearing store: $e');
    return null;
  }
}

Future<dynamic> webGetInfo(dynamic key) async {
  try {
    return await XAppSDKService().getInfo(key);
  } catch (e) {
    print('❌ Error getting info: $e');
    return null;
  }
}
