import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:get/get_core/src/get_main.dart';
import 'package:mypoint_flutter_app/preference/data_preference.dart';
import 'package:mypoint_flutter_app/shared/router_gage.dart';

import '../resources/base_color.dart';

class CustomBackButton extends StatelessWidget {
  final VoidCallback? onPressed;
  final Color? iconColor;
  final double? iconSize;
  final EdgeInsets? margin;

  const CustomBackButton({super.key, this.onPressed, this.iconColor, this.iconSize, this.margin});

  @override
  Widget build(BuildContext context) {
    return SizedBox(
      height: 42,
      width: 42,
      child: Stack(
        children: [
          Center(
            child: Container(
              height: 24,
              width: 24,
              decoration: BoxDecoration(
                border: Border.all(color: BaseColor.second300, width: 1),
                borderRadius: BorderRadius.circular(8),
                color: Colors.white,
              ),
            ),
          ),
          Center(
            child: IconButton(
              icon: Icon(Icons.arrow_back_ios_rounded, color: iconColor ?? BaseColor.second600, size: iconSize ?? 16),
              onPressed:
                  onPressed ??
                  () async {
                    if (Get.key.currentState?.canPop() == true) {
                      Get.back();
                    } else {
                      await DataPreference.instance.clearData();
                      Get.offAllNamed(onboardingScreen);
                    }
                  },
            ),
          ),
        ],
      ),
    );
  }
}
