import 'package:json_annotation/json_annotation.dart';
import 'affiliate_category_type.dart';

part 'affiliate_category_model.g.dart';
@JsonSerializable()
class AffiliateCategoryModel {
  @JsonKey(name: "category_code", fromJson: _codeFromJson, toJson: codeToJson)
  final AffiliateCategoryType code;

  @JsonKey(name: "category_name")
  final String name;

  AffiliateCategoryModel({
    required this.code,
    required this.name,
  });

  static AffiliateCategoryType _codeFromJson(String code) =>
      affiliateCategoryTypeValues[code] ?? AffiliateCategoryType.other;

  static String codeToJson(AffiliateCategoryType type) =>
      affiliateCategoryTypeValues.entries
          .firstWhere((e) => e.value == type,
          orElse: () => const MapEntry("other", AffiliateCategoryType.other))
          .key;

  String get icon => "ic_cashback_${codeToJson(code)}";

  bool get isOther => code == AffiliateCategoryType.other;

  factory AffiliateCategoryModel.fromJson(Map<String, dynamic> json) =>
      _$AffiliateCategoryModelFromJson(json);

  Map<String, dynamic> toJson() => _$AffiliateCategoryModelToJson(this);
}
