import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/core/utils/extensions/string_extension.dart';
import '../../../core/theme/base_color.dart';
import '../../../shared/router_gage.dart';
import '../../../shared/widgets/image_loader.dart';
import '../model/affiliate_brand_model.dart';

class AffiliateBrand extends StatelessWidget {
  final List<AffiliateBrandModel> brands;

  const AffiliateBrand({super.key, required this.brands});

  List<AffiliateBrandModel> get displayBrands {
    return brands.take(6).toList();
  }

  @override
  Widget build(BuildContext context) {
    if (displayBrands.isEmpty) {
      return const SizedBox.shrink();
    }
    final space = 8.0;
    final width = (MediaQuery.of(context).size.width - space * 2 - 32) / 3;
    return Column(
      children: [
        const SizedBox(height: 24),
        Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            const Text("Thương Hiệu Hoàn Điểm", style: TextStyle(fontWeight: FontWeight.bold, fontSize: 20)),
            GestureDetector(
              onTap: () {
                Get.toNamed(affiliateBrandListScreen, arguments: {"brands": brands});
              },
              child: Text(
                "Xem tất cả",
                style: TextStyle(color: BaseColor.primary400, fontSize: 14, fontWeight: FontWeight.w600),
              ),
            ),
          ],
        ),
        const SizedBox(height: 12),
        GridView.builder(
          padding: EdgeInsets.zero,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
          itemCount: displayBrands.length,
          gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
            crossAxisCount: 3,
            childAspectRatio: width / (width + 30),
            crossAxisSpacing: 8,
            mainAxisSpacing: 8,
          ),
          itemBuilder: (context, index) {
            final brand = displayBrands[index];
            return buildAffiliateBrandItem(brand);
          },
        ),
      ],
    );
  }
}

Widget buildAffiliateBrandItem(AffiliateBrandModel brand) {
  return LayoutBuilder(
    builder: (context, constraints) {
      final double imageWidth = constraints.maxWidth / 1.9;
      return GestureDetector(
        onTap: () {
          Get.toNamed(affiliateBrandDetailScreen, arguments: {"brandId": brand.brandId});
        },
        child: Container(
          padding: const EdgeInsets.all(6),
          decoration: BoxDecoration(
            color: Colors.white,
            borderRadius: BorderRadius.circular(8),
            boxShadow: [BoxShadow(color: Colors.black.withOpacity(0.05), blurRadius: 5, offset: const Offset(0, 2))],
          ),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              SizedBox(
                width: imageWidth,
                height: imageWidth,
                child: ClipRRect(
                  borderRadius: BorderRadius.circular(imageWidth),
                  child: loadNetworkImage(
                    url: brand.logo ?? '',
                    width: imageWidth,
                    height: imageWidth,
                    fit: BoxFit.cover,
                  ),
                ),
              ),
              const SizedBox(height: 4),
              Text(
                brand.brandName ?? "",
                maxLines: 1,
                overflow: TextOverflow.ellipsis,
                style: const TextStyle(fontWeight: FontWeight.w600, fontSize: 16),
              ),
              const SizedBox(height: 4),
              RichText(
                textAlign: TextAlign.center,
                text: TextSpan(
                  style: const TextStyle(fontSize: 12),
                  children: [
                    const TextSpan(text: "Hoàn đến: ", style: TextStyle(color: Colors.grey)),
                    TextSpan(
                      text: "${(brand.commision ?? '').toNum()?.toString() ?? ''}%",
                      style: const TextStyle(color: Colors.orange, fontWeight: FontWeight.bold),
                    ),
                  ],
                ),
              ),
            ],
          ),
        ),
      );
    },
  );
}
