import 'package:json_annotation/json_annotation.dart';
import 'brand_category_model.dart';
import '../../home/models/image_model.dart';

part 'brand_model.g.dart';
@JsonSerializable()
class BrandModel {
  @JsonKey(name: 'organization_id')
  final String? organizationId;
  @JsonKey(name: 'organization_code')
  final String? organizationCode;
  @JsonKey(name: 'organization_name')
  final String? organizationName;
  @JsonKey(name: 'brand_id')
  final String? brandId;
  @JsonKey(name: 'brand_code')
  final String? brandCode;
  @JsonKey(name: 'brand_name')
  final String? brandName;
  @JsonKey(name: 'contact_name')
  final String? contactName;
  final String? phone;
  final String? mobile;
  final String? fax;
  final String? email;
  final String? address1;
  final String? address2;
  final String? address3;
  final String? city;
  final String? country;
  final String? website;

  @JsonKey(name: 'point_accumulation_rate')
  final String? pointAccumulationRate;

  final BrandCategoryModel? category;
  final String? logo;
  final List<ImageModel>? images;

  const BrandModel({
    this.organizationId,
    this.organizationCode,
    this.organizationName,
    this.brandId,
    this.brandCode,
    this.brandName,
    this.contactName,
    this.phone,
    this.mobile,
    this.fax,
    this.email,
    this.address1,
    this.address2,
    this.address3,
    this.city,
    this.country,
    this.website,
    this.pointAccumulationRate,
    this.category,
    this.logo,
    this.images,
  });

  factory BrandModel.fromJson(Map<String, dynamic> json) => _$BrandModelFromJson(json);
  Map<String, dynamic> toJson() => _$BrandModelToJson(this);

  String get displayPointAccumulationRate {
    final value = pointAccumulationRate?.replaceAll('%', '') ?? '0';
    final doubleValue = double.tryParse(value) ?? 0;
    return doubleValue.toInt().toString();
  }
}
