import 'package:flutter/material.dart';
import 'package:mypoint_flutter_app/shared/widgets/image_loader.dart';
import '../../../core/theme/base_color.dart';
import '../models/campaign_7day_mission_model.dart';

class Campaign7DayMissionCardItem extends StatelessWidget {
  final Campaign7DayMissionModel mission;
  final VoidCallback? onTapInfo;
  final VoidCallback? onTapClaimReward;
  const Campaign7DayMissionCardItem({super.key, required this.mission, this.onTapInfo, this.onTapClaimReward});

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.symmetric(vertical: 8, horizontal: 4),
      padding: const EdgeInsets.symmetric(vertical: 16, horizontal: 8),
      decoration: BoxDecoration(color: Colors.white, borderRadius: BorderRadius.circular(12)),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          loadNetworkImage(
            url: mission.avatar,
            width: 48,
            height: 48,
            fit: BoxFit.cover,
            placeholderAsset: 'assets/images/ic_point.png',
          ),
          const SizedBox(width: 12),
          Expanded(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text(mission.title ?? '', style: const TextStyle(fontWeight: FontWeight.bold, fontSize: 18)),
                const SizedBox(height: 16),
                Row(
                  children: [
                    Image.asset(
                      mission.reward?.imageAsset ?? 'assets/images/ic_campaign_gift.png',
                      width: 24,
                      height: 24,
                    ),
                    const SizedBox(width: 4),
                    Text(
                      mission.reward?.value ?? '',
                      style: const TextStyle(fontWeight: FontWeight.w700, color: Colors.orange),
                    ),
                  ],
                ),
              ],
            ),
          ),
          Column(
            crossAxisAlignment: CrossAxisAlignment.end,
            mainAxisAlignment: MainAxisAlignment.start,
            children: [
              GestureDetector(onTap: onTapInfo, child: Icon(Icons.info_outline, size: 20, color: BaseColor.primary400)),
              const SizedBox(height: 16),
              ElevatedButton(
                onPressed: mission.isReady ? onTapClaimReward : null,
                style: ElevatedButton.styleFrom(
                  backgroundColor: mission.isReady ? BaseColor.primary400 : BaseColor.second500,
                  shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(20)),
                  padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 0),
                ),
                child: const Text(
                  'Thực hiện',
                  style: TextStyle(fontSize: 14, fontWeight: FontWeight.w800, color: Colors.white),
                ),
              ),
            ],
          ),
        ],
      ),
    );
  }
}
