import 'package:get/get.dart';
import 'package:mypoint_flutter_app/core/network/restful_api_client_all_request.dart';
import 'package:mypoint_flutter_app/features/create_pass/signup_create_password_repository.dart';
import 'package:mypoint_flutter_app/shared/widgets/custom_toast_message.dart';
import '../../shared/widgets/base_view/base_response_model.dart';
import '../../core/network/restful_api_viewmodel.dart';
import '../main_tab_screen/main_tab_screen.dart';

class ChangePasswordRepository extends RestfulApiViewModel implements ICreatePasswordRepository {
  @override
  late String phoneNumber;

  ChangePasswordRepository(this.phoneNumber);

  @override
  Future<BaseResponseModel<EmptyCodable>> setPassword(String password) async {
    showLoading();
    return client.accountPasswordChange(phoneNumber, password).then((value) {
      hideLoading();
      if (value.status == "success" || value.code == 200) {
        showToastMessage("Đổi mật khẩu thành công.");
        Get.off(() => MainTabScreen());
      }
      return value;
    });
  }
}
