class CustomerContractModel {
  String? location;
  String? maKH;
  String? nameKH;
  int? amount;
  String? ky;
  String? idHoaHon;

  CustomerContractModel({
    this.location,
    this.maKH,
    this.nameKH,
    this.amount,
    this.ky,
    this.idHoaHon,
  });

  factory CustomerContractModel.fromJson(Map<String, dynamic> json) {
    return CustomerContractModel(
      location: json['location'],
      maKH: json['ma_khang'],
      nameKH: json['name_khang'],
      amount: json['amount'],
      ky: json['ky'],
      idHoaHon: json['id_hoadon'],
    );
  }

  Map<String, dynamic> toJson() {
    return {
      'location': location,
      'ma_khang': maKH,
      'name_khang': nameKH,
      'amount': amount,
      'ky': ky,
      'id_hoadon': idHoaHon,
    };
  }
}
