import 'package:json_annotation/json_annotation.dart';
import 'package:mypoint_flutter_app/shared/navigation/directional_screen.dart';

part 'banner_model.g.dart';
@JsonSerializable()
class BannerModel {
  @JsonKey(name: 'banner_id')
  final String? bannerID;
  @JsonKey(name: 'item_title')
  final String? itemTitle;
  @JsonKey(name: 'item_image')
  final String? itemImage;
  @JsonKey(name: 'click_action')
  final String? clickAction;
  @JsonKey(name: 'click_action_params')
  final String? clickActionParams;
  @JsonKey(name: 'slider_speed')
  final int? sliderSpeed;

  const BannerModel({
    this.bannerID,
    this.itemTitle,
    this.itemImage,
    this.clickAction,
    this.clickActionParams,
    this.sliderSpeed,
  });

  DirectionalScreen? get directionalScreen {
    return DirectionalScreen.build(
      clickActionType: clickAction,
      clickActionParam: clickActionParams,
    );
  }

  factory BannerModel.fromJson(Map<String, dynamic> json) => _$BannerModelFromJson(json);
  Map<String, dynamic> toJson() => _$BannerModelToJson(this);
}
