import 'package:flutter/material.dart';
import 'package:mypoint_flutter_app/shared/widgets/image_loader.dart';
import '../faqs/faqs_model.dart';

class PageItemWidget extends StatelessWidget {
  final PageItemModel item;

  const PageItemWidget({super.key, required this.item});

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.symmetric(vertical: 6, horizontal: 16),
      padding: const EdgeInsets.all(12),
      decoration: BoxDecoration(
        color: Colors.white,
        borderRadius: BorderRadius.circular(12),
        boxShadow: [BoxShadow(color: Colors.black26, blurRadius: 3, offset: const Offset(2, 1))],
      ),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          // Nội dung văn bản
          Expanded(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text(item.title ?? '', style: const TextStyle(fontWeight: FontWeight.bold, fontSize: 14)),
                const SizedBox(height: 4),
                Text(item.chapeau ?? '', style: const TextStyle(fontSize: 13, color: Colors.black87)),
              ],
            ),
          ),
          const SizedBox(width: 12),
          // Ảnh thumbnail
          ClipRRect(
            borderRadius: BorderRadius.circular(8),
            child: loadNetworkImage(
              url: item.thumbnail ?? '',
              width: 64,
              height: 64,
              fit: BoxFit.cover,
              placeholderAsset: "assets/images/bg_default_11.png",
            ),
          ),
        ],
      ),
    );
  }
}
