import 'package:get/get.dart';
import 'package:mypoint_flutter_app/core/network/restful_api_client_all_request.dart';
import 'package:mypoint_flutter_app/shared/router_gage.dart';
import '../../shared/widgets/base_view/base_response_model.dart';
import '../../core/network/restful_api_viewmodel.dart';
import '../create_pass/create_pass_screen.dart';
import '../create_pass/signup_create_password_repository.dart';
import 'model/otp_verify_response_model.dart';
import 'otp_viewmodel.dart';

class VerifyOtpRepository extends RestfulApiViewModel implements IOtpRepository {
  final String mfaToken;
  VerifyOtpRepository(this.phoneNumber, this.otpTtl, this.mfaToken);

  @override
  int otpTtl;
  @override
  String phoneNumber;

  @override
  Future<void> sendOtp() async {}

  @override
  Future<BaseResponseModel<OTPVerifyResponseModel>> verifyOtp(String otpCode) async {
    showLoading();
    return client.verifyOTP(otpCode, mfaToken).then((value) {
      hideLoading();
      if (value.data?.claim?.action == "signup") {
        Get.off(() => CreatePasswordScreen(repository: SignUpCreatePasswordRepository(phoneNumber)));
      } else if (value.data?.claim?.action == "login") {
        Get.offNamed(loginScreen, arguments: {'phone': phoneNumber});
      }
      return value;
    });
  }

  @override
  Future<int?> resendOtp() async {
      showLoading();
      return client.resendOTP(mfaToken).then((value) {
        hideLoading();
        return value.data?.otpTtl;
      });
  }
}
