import 'package:mypoint_flutter_app/shared/navigation/directional_screen.dart';

class PipiSupportItemModel {
  final String? id;
  final String? icon;
  final String? title;
  final String? clickActionType;
  final String? clickActionParam;

  PipiSupportItemModel({
    this.id,
    this.icon,
    this.title,
    this.clickActionType,
    this.clickActionParam,
  });

  DirectionalScreen? get directionScreen {
    return DirectionalScreen.build(
      clickActionType: clickActionType,
      clickActionParam: clickActionParam,
    );
  }

  factory PipiSupportItemModel.fromJson(Map<String, dynamic> json) => PipiSupportItemModel(
    id: json['id'] as String?,
    icon: json['icon'] as String?,
    title: json['title'] as String?,
    clickActionType: json['click_action_type'] as String?,
    clickActionParam: json['click_action_param'] as String?,
  );
}

class PipiDetailResponseModel {
  final List<PipiSupportItemModel>? items;

  PipiDetailResponseModel({
    this.items,
  });

  factory PipiDetailResponseModel.fromJson(Map<String, dynamic> json) => PipiDetailResponseModel(
    items: (json['list_items'] as List<dynamic>?)
        ?.map((e) => PipiSupportItemModel.fromJson(e as Map<String, dynamic>))
        .toList(),
  );
}