enum InputDataDefaultCode {
  fullName,
  phoneNumber,
  birthDate,
  locationDistrictCode,
  locationProvinceCode,
  email,
  addressFull,
}

extension InputDataDefaultCodeExtension on InputDataDefaultCode {
  static InputDataDefaultCode? fromRaw(String? raw) {
    switch (raw) {
      case 'FULL_NAME':
        return InputDataDefaultCode.fullName;
      case 'PHONE_NUMBER':
        return InputDataDefaultCode.phoneNumber;
      case 'BIRTH_DATE':
        return InputDataDefaultCode.birthDate;
      case 'LOCATION_DISTRICT_CODE':
        return InputDataDefaultCode.locationDistrictCode;
      case 'LOCATION_PROVINCE_CODE':
        return InputDataDefaultCode.locationProvinceCode;
      case 'EMAIL':
        return InputDataDefaultCode.email;
      case 'ADDRESS_FULL':
        return InputDataDefaultCode.addressFull;
      default:
        return null;
    }
  }
}
