import 'package:mypoint_flutter_app/features/transaction/history/transaction_history_model.dart';

class TransactionHistoryResponse {
  List<TransactionHistoryModel>? items;
  TransactionHistorySummaryModel? summary;

  TransactionHistoryResponse({this.items, this.summary});

  factory TransactionHistoryResponse.fromJson(Map<String, dynamic> json) {
    return TransactionHistoryResponse(
      items: (json['items'] as List<dynamic>?)
          ?.map((e) => TransactionHistoryModel.fromJson(e))
          .toList(),
      summary: json['summary'] != null
          ? TransactionHistorySummaryModel.fromJson(json['summary'])
          : null,
    );
  }

  Map<String, dynamic> toJson() {
    return {
      'items': items?.map((e) => e.toJson()).toList(),
      'summary': summary?.toJson(),
    };
  }
}

class TransactionHistorySummaryModel {
  String? total;
  String? totalPayCash;
  String? totalPayPoint;
  int? totalOrder;

  TransactionHistorySummaryModel({
    this.total,
    this.totalPayCash,
    this.totalPayPoint,
    this.totalOrder,
  });

  factory TransactionHistorySummaryModel.fromJson(Map<String, dynamic> json) {
    return TransactionHistorySummaryModel(
      total: json['total'],
      totalPayCash: json['total_pay_cash'],
      totalPayPoint: json['total_pay_point'],
      totalOrder: json['total_order'],
    );
  }

  Map<String, dynamic> toJson() {
    return {
      'total': total,
      'total_pay_cash': totalPayCash,
      'total_pay_point': totalPayPoint,
      'total_order': totalOrder,
    };
  }
}

