import 'package:flutter/material.dart';
import '../../../app/routing/directional_action_type.dart';
import '../../../shared/navigation/directional_screen.dart';

class VoucherActionMenu extends StatelessWidget {
  const VoucherActionMenu({super.key});

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.symmetric(vertical: 12),
      child: Row(
        children: const [
          _ActionItem(icon: "assets/images/ic_topup.png", label: 'Nạp tiền\ndiện thoại', type: DirectionalScreenName.topup,),
          _ActionItem(icon: "assets/images/ic_card_code.png", label: 'Đổi mã\nthẻ nạp', type: DirectionalScreenName.productMobileCard,),
          _ActionItem(icon: "assets/images/ic_sim_service.png", label: 'Gói cước\nnhà mạng', type: DirectionalScreenName.simService,),
          _ActionItem(icon: "assets/images/ic_topup_data.png", label: 'Ưu đãi\nData', type: DirectionalScreenName.mobileTopupData,),
        ],
      ),
    );
  }
}

class _ActionItem extends StatelessWidget {
  final String icon;
  final String label;
  final DirectionalScreenName type;

  const _ActionItem({required this.icon, required this.label, required this.type});

  @override
  Widget build(BuildContext context) {
    final screenWidth = MediaQuery.of(context).size.width;
    final itemWidth = screenWidth / 4;

    return GestureDetector(
      onTap: () {
        DirectionalScreen? screen = DirectionalScreen.build(
          clickActionType: type.rawValue,
        );
        screen?.begin();
      },
      child: SizedBox(
        width: itemWidth,
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            Image.asset(
              icon,
              fit: BoxFit.cover,
              width: 40,
              height: 40,
            ),
            const SizedBox(height: 8),
            Text(
              label,
              style: const TextStyle(fontSize: 12),
              textAlign: TextAlign.center,
              maxLines: 2,
              overflow: TextOverflow.ellipsis,
            ),
          ],
        ),
      ),
    );
  }
}
