import 'dart:math';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/shared/router_gage.dart';
import '../../../core/theme/base_color.dart';
import '../../../shared/widgets/custom_price_tag.dart';
import '../../../shared/widgets/image_loader.dart';
import '../models/product_model.dart';

class VoucherItemList extends StatelessWidget {
  final List<ProductModel> items;
  const VoucherItemList({super.key, required this.items});

  @override
  Widget build(BuildContext context) {
    return ListView.builder(
      itemCount: items.length,
      shrinkWrap: true,
      physics: const NeverScrollableScrollPhysics(),
      itemBuilder: (context, index) {
        final product = items[index];
        return GestureDetector(
          onTap: () {
            Get.toNamed(voucherDetailScreen, arguments: {"productId": product.id});
            },
          child: VoucherListItem(product: product),
        );
      },
    );
  }
}

class VoucherListItem extends StatelessWidget {
  final ProductModel product;
  const VoucherListItem({super.key, required this.product});

  @override
  Widget build(BuildContext context) {
    final productName = product.content?.name ?? '';
    final brandName = product.brand?.name ?? '';
    final brandLogo = product.brand?.logo ?? '';
    final String? bgImage = product.banner?.url;
    final widthImage = MediaQuery.of(context).size.width/2-32;
    final heightImage = widthImage*9/16;

    return Column(
      children: [
        Padding(
          padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 8),
          child: SizedBox(
            height: max(heightImage, 112),
            child: Row(
              children: [
                ClipRRect(
                  borderRadius: BorderRadius.circular(8),
                  child: Stack(
                    children: [
                      AspectRatio(
                        aspectRatio: 16 / 9,
                        child: loadNetworkImage(
                          url: bgImage,
                          fit: BoxFit.cover,
                          placeholderAsset: 'assets/images/bg_default_169.png',
                        ),
                      ),
                      if (!product.inStock)
                        Positioned.fill(
                          child: Container(
                            color: Colors.black.withOpacity(0.3),
                            alignment: Alignment.center,
                            child: const Text(
                              'Tạm hết',
                              style: TextStyle(
                                color: Colors.white,
                                fontSize: 16,
                                fontWeight: FontWeight.bold,
                              ),
                            ),
                          ),
                        ),
                    ],
                  ),
                ),
                const SizedBox(width: 12),
                Expanded(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    mainAxisAlignment: MainAxisAlignment.start,
                    children: [
                      Text(
                        productName,
                        style: const TextStyle(fontSize: 13, fontWeight: FontWeight.w500),
                        maxLines: 2,
                        overflow: TextOverflow.ellipsis,
                      ),
                      const SizedBox(height: 8),
                      Row(
                        crossAxisAlignment: CrossAxisAlignment.center,
                        children: [
                          CircleAvatar(
                            radius: 10,
                            backgroundColor: Colors.transparent,
                            child: ClipOval(
                              child: loadNetworkImage(
                                url: brandLogo,
                                width: 16,
                                height: 16,
                                fit: BoxFit.cover,
                                placeholderAsset: 'assets/images/ic_logo.png',
                              ),
                            ),
                          ),
                          const SizedBox(width: 4),
                          Expanded(
                            child: Text(
                              brandName,
                              style: const TextStyle(fontSize: 11),
                              overflow: TextOverflow.ellipsis,
                            ),
                          ),
                        ],
                      ),
                      const SizedBox(height: 8),
                      PriceTagWidget(point: product.amountToBePaid ?? 0, type: product.price?.method,),
                    ],
                  ),
                ),
              ],
            ),
          ),
        ),
        Padding(
          padding: const EdgeInsets.symmetric(horizontal: 16),
          child: Divider(height: 1, thickness: 1, color: BaseColor.second200),
        ),
      ],
    );
  }
}
