# MyPoint Flutter App - Simple Commands

## 🚀 **Lệnh chính:**

### **Development (chạy local):**
```bash
./run_dev.sh
```

### **Export Development (để test trên server):**
```bash
./export_dev.sh
```

### **Export Production:**
```bash
./run_prod.sh
```

## 🔧 **Lệnh phụ:**

### **Chuyển đổi môi trường:**
```bash
# Development
./scripts/switch_env.sh dev

# Production
./scripts/switch_env.sh prod
```

### **Chạy web với CORS fix:**
```bash
./scripts/run_web_complete.sh
./scripts/open_browser_cors_disabled.sh
```


## 📁 **Cấu trúc đơn giản:**

```
flutter_app_mypoint/
├── run_dev.sh                    # Chạy development
├── run_prod.sh                   # Export production
├── export_web.sh                 # Export web app
├── assets/config/
│   ├── env.json                  # Config chính
│   └── env_dev.json              # Config dev
├── scripts/
│   ├── switch_env.sh             # Chuyển đổi môi trường
│   ├── run_web_complete.sh       # Chạy web với CORS
│   ├── open_browser_cors_disabled.sh  # Mở Chrome với CORS disabled
    └── test_web.sh             # Test web
└── lib/web/                      # Web integration
```

## ✅ **Kết quả:**
- ✅ **Đơn giản**: Chỉ 2 lệnh chính
- ✅ **Dễ nhớ**: `./run_dev.sh` và `./run_prod.sh`
- ✅ **Web**: Tích hợp đầy đủ
- ✅ **Sẵn sàng**: Chạy ngay
