# Core App Architecture

## Overview
This directory contains the core initialization and configuration logic for the app, separated from the main.dart file for better organization and maintainability.

## Files

### `app_initializer.dart`
Main app initialization orchestrator that coordinates all app features:

- **Environment loading** (`loadEnv()`)
- **Data preferences** initialization
- **HTTP service** setup
- **GetX controllers** registration
- **Firebase** initialization (mobile only)
- **User point** fetching (if logged in)
- **Web-specific** features initialization
- **Post-initialization** callbacks setup

### `web_app_initializer.dart`
Web-specific initialization and configuration:

- **URL parameters** handling
- **X-App-SDK** integration
- **Super App** communication
- **Fallback methods** for data retrieval
- **Retry mechanisms** for data loading

## Usage

### Main App Initialization
```dart
void main() async {
  WidgetsFlutterBinding.ensureInitialized();
  
  // Initialize all app features
  await AppInitializer.initialize();
  
  // Run the app
  runApp(const MyApp());
  
  // Setup post-initialization callbacks
  AppInitializer.setupPostInitCallbacks();
}
```

### Web-Specific Initialization
```dart
// Automatically called by AppInitializer.initialize()
await WebAppInitializer.initialize();
```

## Benefits

1. **Separation of Concerns**: Web logic separated from core app logic
2. **Maintainability**: Easier to modify and test individual components
3. **Readability**: Main.dart is now clean and focused
4. **Reusability**: Initialization logic can be reused in tests
5. **Modularity**: Easy to add new platform-specific initializers

## Architecture

```
main.dart
├── AppInitializer.initialize()
│   ├── Environment loading
│   ├── Data preferences
│   ├── HTTP service
│   ├── GetX controllers
│   ├── Firebase (mobile only)
│   ├── User point fetching
│   └── WebAppInitializer.initialize()
│       ├── URL parameters handling
│       ├── X-App-SDK initialization
│       └── Super App communication
└── AppInitializer.setupPostInitCallbacks()
    ├── App loading
    ├── Notification handling
    └── Other post-init tasks
```


