import 'package:get/get.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../networking/restful_api_viewmodel.dart';
import '../../preference/data_preference.dart';
import '../home/models/achievement_model.dart';

class AchievementViewModel extends RestfulApiViewModel {
  final bool isPointHunting;
  final RxList<AchievementModel> achievements = <AchievementModel>[].obs;
  
  AchievementViewModel({this.isPointHunting = false});

  @override
  void onInit() {
    super.onInit();
    fetchAchievements();
  }

  Future<void> fetchAchievements() async {
    String? token = DataPreference.instance.token ?? "";
    final body = {
      "access_token": token,
      "achievement_type": isPointHunting ? "Hunt_Point": "Earn_Point",
      "start": 0,
      "limit": 1000,
    };
    
    await callApi<AchievementListResponse>(
      request: () => client.getAchievementList(body),
      onSuccess: (data, _) {
        achievements.assignAll(data?.achievements ?? []);
      },
      onFailure: (msg, _, __) async {
        achievements.clear();
      },
      showAppNavigatorDialog: false,
    );
  }
}