import 'package:flutter/material.dart';
import 'package:flutter_widget_from_html/flutter_widget_from_html.dart';

class AffiliateOverviewPopup extends StatelessWidget {
  final List<String> descriptions;

  const AffiliateOverviewPopup({super.key, required this.descriptions});

  @override
  Widget build(BuildContext context) {
    return Dialog(
      insetPadding: const EdgeInsets.symmetric(horizontal: 8, vertical: 8),
      backgroundColor: Colors.white,
      shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(24)),
      child: Padding(
        padding: const EdgeInsets.all(4), // ✅ padding tổng thể
        child: Column(
          mainAxisSize: MainAxisSize.min,
          children: [
            // Header
            Row(
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                const Spacer(),
                const Expanded(
                  flex: 6,
                  child: Text(
                    'Hoàn điểm là gì?',
                    textAlign: TextAlign.center, // ✅ căn giữa
                    style: TextStyle(fontWeight: FontWeight.bold, fontSize: 24),
                  ),
                ),
                Expanded(
                  child: IconButton(
                    icon: const Icon(Icons.close),
                    onPressed: () => Navigator.of(context).pop(),
                  ),
                )
              ],
            ),
            const SizedBox(height: 12),
            // Descriptions
            ...descriptions.map(
                  (html) => Padding(
                padding: const EdgeInsets.only(bottom: 12),
                child: Container(
                  width: double.infinity,
                  padding: const EdgeInsets.all(12),
                  decoration: BoxDecoration(
                    color: Colors.grey.shade100,
                    borderRadius: BorderRadius.circular(12),
                  ),
                  child: HtmlWidget(html),
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }
}