import 'package:flutter/material.dart';

enum AffiliateTipBoxType {
  should,
  shouldnt,
  note,
  other;
}

extension AffiliateTipBoxTypeExt on AffiliateTipBoxType {
  String get title {
    switch (this) {
      case AffiliateTipBoxType.should:
        return "NÊN";
      case AffiliateTipBoxType.shouldnt:
        return "KHÔNG NÊN";
      case AffiliateTipBoxType.note:
        return "Ghi chú";
      case AffiliateTipBoxType.other:
        return "Thông tin khác";
    }
  }

  Color get backgroundColor {
    switch (this) {
      case AffiliateTipBoxType.should:
        return Colors.green.shade100;
      case AffiliateTipBoxType.shouldnt:
        return Colors.red.shade50;
      case AffiliateTipBoxType.note:
        return Colors.white;
      case AffiliateTipBoxType.other:
        return Colors.white;
    }
  }

  Color get textColor {
    switch (this) {
      case AffiliateTipBoxType.should:
        return Colors.green.shade600;
      case AffiliateTipBoxType.shouldnt:
        return Colors.red.shade800;
      case AffiliateTipBoxType.note:
        return Colors.black87;
      case AffiliateTipBoxType.other:
        return Colors.black87;
    }
  }

  IconData get icon {
    switch (this) {
      case AffiliateTipBoxType.should:
        return Icons.check_circle;
      case AffiliateTipBoxType.shouldnt:
        return Icons.cancel;
      case AffiliateTipBoxType.note:
        return Icons.info;
      case AffiliateTipBoxType.other:
        return Icons.lightbulb;
    }
  }

  Color get iconColor {
    switch (this) {
      case AffiliateTipBoxType.should:
        return Colors.green;
      case AffiliateTipBoxType.shouldnt:
        return Colors.red;
      case AffiliateTipBoxType.note:
        return Colors.grey;
      case AffiliateTipBoxType.other:
        return Colors.blue;
    }
  }
}


class AffiliateBrandDetailTipBox extends StatelessWidget {
  final AffiliateTipBoxType type;
  final List<String> tips;

  const AffiliateBrandDetailTipBox({super.key, required this.type, required this.tips});

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.only(left: 16, right: 16, bottom: 16), //all(16),
      padding: const EdgeInsets.all(12),
      decoration: BoxDecoration(
        color: type.backgroundColor,
        borderRadius: BorderRadius.circular(8),
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(
            type.title,
            style: TextStyle(
              color: type.textColor,
              fontWeight: FontWeight.bold,
              fontSize: 16,
            ),
          ),
          const SizedBox(height: 8),
          ...tips.map((tip) => Padding(
            padding: const EdgeInsets.symmetric(vertical: 4),
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Icon(type.icon, color: type.iconColor, size: 20),
                const SizedBox(width: 8),
                Expanded(
                  child: Text(
                    tip,
                    style: const TextStyle(fontSize: 14, color: Colors.black87),
                  ),
                ),
              ],
            ),
          )),
        ],
      ),
    );
  }
}
