import 'package:get/get.dart';
import 'package:mypoint_flutter_app/configs/constants.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../networking/restful_api_viewmodel.dart';
import 'models/affiliate_brand_detail_model.dart';

class AffiliateBrandDetailViewModel extends RestfulApiViewModel {
  final String brandId;
  AffiliateBrandDetailViewModel(this.brandId);

  void Function(String message)? onShowAlertError;
  final Rxn<AffiliateBrandDetailModel> brandDetailData = Rxn<AffiliateBrandDetailModel>();

  @override
  void onInit() {
    super.onInit();
    _fetchDetail();
  }

  Future<void> _fetchDetail() async {
    await callApi<AffiliateBrandDetailModel>(
      request: () => client.getAffiliateBrandDetail(brandId),
      onSuccess: (data, _) {
        brandDetailData.value = data;
      },
      onFailure: (msg, _, _) async {
        brandDetailData.value = null;
        onShowAlertError?.call(msg.isNotEmpty ? msg : Constants.commonError);
      },
    );
  }
}
