import 'package:get/get.dart';
import 'package:mypoint_flutter_app/configs/constants.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import 'package:mypoint_flutter_app/widgets/custom_toast_message.dart';
import '../../networking/restful_api_viewmodel.dart';
import 'bank_account_info_model.dart';

class BankAccountDetailViewModel extends RestfulApiViewModel {
  final BankAccountInfoModel model;

  void Function(String message)? onShowAlertError;
  void Function(String message)? deleteBackAccountSuccess;
  var isDefault = false.obs;

  BankAccountDetailViewModel({required this.model});

  Future<void> changeDefaultBankAccount() async {
    final revertDefault = !isDefault.value;
    final accountId = model.id.toString();
    await callApi<String?>(
      request: () => client.setDefaultBankAccount(accountId, revertDefault),
      onSuccess: (data, _) {
        isDefault.value = revertDefault;
        showToastMessage(data ?? "Cập nhật thành công");
      },
      onFailure: (msg, _, _) async {
        onShowAlertError?.call(msg.isNotEmpty ? msg : Constants.commonError);
      },
    );
  }

  Future<void> deleteBankAccount() async {
    final accountId = model.id.toString();
    await callApi<String?>(
      request: () => client.deleteBankAccount(accountId),
      onSuccess: (data, _) {
        deleteBackAccountSuccess?.call(data ?? "Xoá tài khoản thành công");
      },
      onFailure: (msg, _, _) async {
        onShowAlertError?.call(msg.isNotEmpty ? msg : Constants.commonError);
      },
    );
  }
}