import 'package:flutter/material.dart';
import 'package:flutter_widget_from_html/flutter_widget_from_html.dart';
import '../../resources/base_color.dart';

class Campaign7DayGuideDialog extends StatelessWidget {
  final String title;
  final String htmlContent;
  final VoidCallback onClose;

  const Campaign7DayGuideDialog({super.key, required this.title, required this.htmlContent, required this.onClose});

  @override
  Widget build(BuildContext context) {
    final widthScreen = MediaQuery.of(context).size.width;
    final heightScreen = MediaQuery.of(context).size.height;
    return Stack(
      children: [
        Container(
          padding: const EdgeInsets.only(top: 32),
          child: Stack(
            clipBehavior: Clip.none,
            children: [
              Container(
                decoration: BoxDecoration(color: const Color(0xFFFCECEF), borderRadius: BorderRadius.circular(24)),
                child: Column(
                  mainAxisSize: MainAxisSize.min,
                  children: [
                    Padding(
                      padding: const EdgeInsets.only(top: 24, left: 16, right: 16, bottom: 16),
                      child: Row(
                        children: [
                          Expanded(
                            child: Text(
                              title,
                              style: TextStyle(color: BaseColor.primary400, fontSize: 24, fontWeight: FontWeight.w800),
                            ),
                          ),
                          SizedBox(width: widthScreen / 2.5),
                        ],
                      ),
                    ),
                    const SizedBox(height: 8),
                    Container(
                      margin: const EdgeInsets.symmetric(horizontal: 16),
                      padding: const EdgeInsets.all(16),
                      decoration: BoxDecoration(color: Colors.white, borderRadius: BorderRadius.circular(20)),
                      constraints: BoxConstraints(maxHeight: heightScreen*0.6),
                      child: SingleChildScrollView(
                        child: HtmlWidget(htmlContent, textStyle: const TextStyle(fontSize: 16, height: 1.5)),
                      ),
                    ),
                    const SizedBox(height: 24),
                  ],
                ),
              ),
              Positioned(
                top: -30,
                right: 0,
                child: Image.asset('assets/images/bg_header_campaign_info.png', width: widthScreen / 1.6),
              ),
            ],
          ),
        ),
        Positioned(
          top: 0,
          right: 8,
          child: GestureDetector(
            onTap: onClose,
            child: Container(
              padding: const EdgeInsets.all(2),
              decoration: const BoxDecoration(
                shape: BoxShape.circle,
                border: Border.fromBorderSide(BorderSide(color: Colors.white, width: 1.5)),
              ),
              child: const Icon(Icons.close_outlined, color: Colors.white, size: 20),
            ),
          ),
        ),
      ],
    );
  }
}
