import 'package:flutter/material.dart';
import 'custom_widgets/campaign_7day_reward_item.dart';
import 'models/campaign_7day_reward_model.dart';

class Campaign7DayRewardDialog extends StatelessWidget {
  final List<Campaign7DayRewardModel> rewards;
  final VoidCallback onClose;

  const Campaign7DayRewardDialog({super.key, required this.rewards, required this.onClose});

  @override
  Widget build(BuildContext context) {
    return Dialog(
      backgroundColor: Colors.transparent,
      insetPadding: const EdgeInsets.all(16),
      child: Stack(
        children: [
          Container(
            padding: const EdgeInsets.only(top: 32),
            child: Stack(
              clipBehavior: Clip.none,
              children: [
                Container(
                  decoration: BoxDecoration(color: const Color(0xFFFCECEF), borderRadius: BorderRadius.circular(24)),
                  padding: const EdgeInsets.only(top: 48, left: 16, right: 16, bottom: 24),
                  child: ConstrainedBox(
                    constraints: BoxConstraints(
                      maxHeight: MediaQuery.of(context).size.height * 0.7, // 70% chiều cao màn hình
                    ),
                    child: ListView.separated(
                      shrinkWrap: true,
                      physics: const BouncingScrollPhysics(),
                      itemCount: rewards.length,
                      separatorBuilder: (_, __) => const SizedBox(height: 12),
                      itemBuilder: (context, index) {
                        return Campaign7DayRewardItem(model: rewards[index]);
                      },
                    ),
                  ),
                ),
                Positioned(
                  top: -9,
                  left: 0,
                  right: 0,
                  child: Center(
                    child: Stack(
                      alignment: Alignment.center,
                      children: [
                        Image.asset('assets/images/ic_header_alert_campaign.png', height: 48, fit: BoxFit.contain),
                        const Text(
                          'Lịch sử phần thưởng',
                          style: TextStyle(color: Colors.white, fontWeight: FontWeight.w800, fontSize: 17),
                        ),
                      ],
                    ),
                  ),
                ),
              ],
            ),
          ),
          Positioned(
            top: 0,
            right: 8,
            child: GestureDetector(
              onTap: onClose,
              child: Container(
                padding: const EdgeInsets.all(2),
                decoration: const BoxDecoration(
                  shape: BoxShape.circle,
                  border: Border.fromBorderSide(BorderSide(color: Colors.white, width: 1.5)),
                ),
                child: const Icon(Icons.close_outlined, color: Colors.white, size: 20),
              ),
            ),
          ),
        ],
      ),
    );
  }
}
