import 'package:flutter/material.dart';

class Campaign7dayTopButtons extends StatelessWidget {
  final VoidCallback? onBack;
  final VoidCallback? onInfo;
  final VoidCallback? onGift;

  const Campaign7dayTopButtons({
    super.key,
    this.onBack,
    this.onInfo,
    this.onGift,
  });

  @override
  Widget build(BuildContext context) {
    return SafeArea(
      child: Padding(
        padding: const EdgeInsets.symmetric(horizontal: 16.0, vertical: 8),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            _buildIconButton("assets/images/ic_campaign_back.png", onBack),
            Row(
              children: [
                _buildIconButton("assets/images/ic_campaign_info.png", onInfo),
                const SizedBox(width: 12),
                _buildIconButton("assets/images/ic_campaign_gift.png", onGift),
              ],
            ),
          ],
        ),
      ),
    );
  }

  Widget _buildIconButton(String assetName, VoidCallback? onPressed) {
    return GestureDetector(
      onTap: onPressed,
      child: SizedBox(
        width: 40,
        height: 40,
        child: Image.asset(
          assetName,
          // color: Colors.white,
          width: 22,
          height: 22,
        ),
      ),
    );
  }
}
