import 'package:get/get_rx/src/rx_types/rx_types.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../configs/constants.dart';
import '../../networking/restful_api_viewmodel.dart';
import 'health_book_model.dart';

class HealthBookCardDetailViewModel extends RestfulApiViewModel {
  final Rxn<HealthBookCardItemModel> card = Rxn<HealthBookCardItemModel>();
  void Function(String message)? onShowAlertError;

  Future<void> getHealthBookCardDetail(String cardId) async {
    await callApi<HealthBookCardItemModel>(
      request: () => client.getDetailHealthBookCard(cardId),
      onSuccess: (data, _) {
        card.value = data;
      },
      onFailure: (msg, _, _) async {
        onShowAlertError?.call(msg);
      },
    );
  }
}