import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/widgets/custom_empty_widget.dart';
import '../../resources/base_color.dart';
import '../../shared/router_gage.dart';
import '../../widgets/custom_navigation_bar.dart';
import '../traffic_service/traffic_service_model.dart';
import 'health_book_viewmodel.dart';
import 'widgets/health_book_item.dart';

class HealthBookScreen extends StatefulWidget {
  const HealthBookScreen({super.key});

  @override
  State<HealthBookScreen> createState() => _HealthBookScreenState();
}

class _HealthBookScreenState extends State<HealthBookScreen> {
  final HealthBookViewModel _viewModel = Get.put(HealthBookViewModel());

  @override
  void initState() {
    super.initState();
    _viewModel.getHealthBookCards();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: CustomNavigationBar(title: "Sổ sức khoẻ điện tử"),
      body: Column(
        children: [
          const SizedBox(height: 8),
          Obx(() => SizedBox(child: _buildTag())),
          const Divider(height: 14, color: Colors.black12),
          const SizedBox(height: 8),
          Expanded(
            child: Obx(() {
              final products = _viewModel.healthBookData.value?.products ?? [];
              return products.isEmpty
                  ? Center(child: EmptyWidget())
                  : ListView.builder(
                    itemCount: products.length,
                    itemBuilder: (context, index) {
                      final item = products[index];
                      return Padding(
                        padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 4),
                        child: HealthBookItem(
                          item: item,
                          onTap: () {
                            Get.toNamed(healthBookCardDetail, arguments: {'health_book_card': item, 'id': item.itemId.toString() ?? ''});
                          },
                        ),
                      );
                    },
                  );
            }),
          ),
        ],
      ),
    );
  }

  Widget _buildTag() {
    final tags = _viewModel.headerFilterOrder;
    return SingleChildScrollView(
      scrollDirection: Axis.horizontal,
      physics: const BouncingScrollPhysics(),
      padding: const EdgeInsets.symmetric(horizontal: 4),
      child: Row(
        children: List.generate(tags.length, (index) {
          final item = tags[index];
          final isSelected = index == _viewModel.selectedIndex.value;
          return GestureDetector(
            onTap: () {
              if (_viewModel.selectedIndex.value == index && item.sort == null) return;
              setState(() {
                if (item.sort == SortFilter.asc) {
                  tags[index].sort = SortFilter.desc;
                } else if (item.sort == SortFilter.desc) {
                  tags[index].sort = SortFilter.asc;
                }
                _viewModel.selectedIndex.value = index;
                _viewModel.getHealthBookCards();
              });
            },
            child: Container(
              height: 52,
              margin: const EdgeInsets.symmetric(horizontal: 8, vertical: 4),
              padding: const EdgeInsets.symmetric(horizontal: 12, vertical: 12),
              decoration: BoxDecoration(
                border: Border.all(color: isSelected ? BaseColor.primary500 : Colors.grey.shade300),
                borderRadius: BorderRadius.circular(8),
              ),
              child: Row(
                children: [
                  Text(
                    item.title,
                    maxLines: 1,
                    overflow: TextOverflow.ellipsis,
                    softWrap: false,
                    style: TextStyle(color: isSelected ? BaseColor.primary500 : Colors.black87),
                  ),
                  if (item.sort != null)
                    Row(
                      children: [
                        const SizedBox(width: 4),
                        SizedBox(
                          height: 24,
                          child: Column(
                            children: [
                              Icon(
                                Icons.keyboard_double_arrow_up_sharp,
                                size: 12,
                                color:
                                    (isSelected && item.sort == SortFilter.asc) ? BaseColor.primary500 : Colors.black54,
                              ),
                              Icon(
                                Icons.keyboard_double_arrow_down_sharp,
                                size: 12,
                                color:
                                    (isSelected && item.sort == SortFilter.desc)
                                        ? BaseColor.primary500
                                        : Colors.black54,
                              ),
                            ],
                          ),
                        ),
                      ],
                    ),
                ],
              ),
            ),
          );
        }),
      ),
    );
  }
}
