enum HeaderSectionType {
  profileHeader,
  topButton,
  banner,
  flashSale,
  brand,
  pointPartner,
  campaign,
  product,
  myProduct,
  news,
}

extension HeaderSectionTypeExtension on HeaderSectionType {
  String get key {
    switch(this) {
      case HeaderSectionType.profileHeader:
        return "LOCAL_PROFILE_HEADER";
      case HeaderSectionType.topButton:
        return "QUICK_BUTTONS";
      case HeaderSectionType.banner:
        return "BANNERS";
      case HeaderSectionType.flashSale:
        return "FLASH_SALE";
      case HeaderSectionType.brand:
        return "BRANDS";
      case HeaderSectionType.pointPartner:
        return "POINT_PARTNERS";
      case HeaderSectionType.campaign:
        return "CAMPAIGNS";
      case HeaderSectionType.product:
        return "PRODUCTS";
      case HeaderSectionType.myProduct:
        return "MY_VOUCHERS";
      case HeaderSectionType.news:
        return "MYPOINT_HOT";
    }
  }

  static HeaderSectionType? fromString(String value) {
    switch (value) {
      case "LOCAL_PROFILE_HEADER":
        return HeaderSectionType.profileHeader;
      case "QUICK_BUTTONS":
        return HeaderSectionType.topButton;
      case "BANNERS":
        return HeaderSectionType.banner;
      case "FLASH_SALE":
        return HeaderSectionType.flashSale;
      case "BRANDS":
        return HeaderSectionType.brand;
      case "POINT_PARTNERS":
        return HeaderSectionType.pointPartner;
      case "CAMPAIGNS":
        return HeaderSectionType.campaign;
      case "PRODUCTS":
        return HeaderSectionType.product;
      case "MY_VOUCHERS":
        return HeaderSectionType.myProduct;
      case "MYPOINT_HOT":
        return HeaderSectionType.news;
      default:
        return null;
    }
  }
}
