import 'package:json_annotation/json_annotation.dart';
import 'package:mypoint_flutter_app/directional/directional_screen.dart';
import '../../flash_sale/models/preview_flash_sale_model.dart';
import 'header_section_type.dart';

part 'main_section_config_model.g.dart';
@JsonSerializable()
class MainSectionConfigModel {
  final int? id;
  final String? name;
  final String? type;
  final String? layout;
  @JsonKey(name: 'slider_speed')
  final int? sliderSpeed;
  final int? order;
  @JsonKey(name: 'api_list')
  final String? apiList;
  @JsonKey(name: 'button_view_all')
  final MainHeaderConfigRightButton? buttonViewAll;
  @JsonKey(name: 'flash_sale')
  final PreviewFlashSale? flashSale;

  HeaderSectionType? get headerSectionType {
    return HeaderSectionTypeExtension.fromString(type ?? "");
  }

  MainSectionConfigModel({
    this.id,
    this.name,
    this.type,
    this.layout,
    this.sliderSpeed,
    this.order,
    this.apiList,
    this.buttonViewAll,
    this.flashSale,
  });

  factory MainSectionConfigModel.fromJson(Map<String, dynamic> json) => _$MainSectionConfigModelFromJson(json);
  Map<String, dynamic> toJson() => _$MainSectionConfigModelToJson(this);
}

class MainHeaderConfigRightButton {
  final String? text;
  final String? clickActionType;
  final String? clickActionParam;

  MainHeaderConfigRightButton({this.text, this.clickActionType, this.clickActionParam});

  DirectionalScreen? get directionalScreen {
    return DirectionalScreen.build(
      clickActionType: clickActionType,
      clickActionParam: clickActionParam,
    );
  }

  factory MainHeaderConfigRightButton.fromJson(Map<String, dynamic> json) {
    return MainHeaderConfigRightButton(
      text: json['text'] as String?,
      clickActionType: json['click_action_type'] as String?,
      clickActionParam: json['click_action_param'] as String?,
    );
  }

  Map<String, dynamic> toJson() {
    return {'text': text, 'click_action_type': clickActionType, 'click_action_param': clickActionParam};
  }
}