import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../resources/base_color.dart';
import '../affiliate/affiliate_tab_screen.dart';
import '../game/game_tab_screen.dart';
import '../home/header_home_viewmodel.dart';
import '../home/home_screen.dart';
import '../personal/personal_screen.dart';
import '../voucher/voucher_tab_screen.dart';

class MainTabScreen extends StatefulWidget {
  const MainTabScreen({super.key});

  @override
  State<MainTabScreen> createState() => _MainTabScreenState();
}

class _MainTabScreenState extends State<MainTabScreen> {
  int _currentIndex = 0;

  final List<Widget> _pages = const [
    HomeScreen(),
    VoucherTabScreen(),
    GameTabScreen(),
    AffiliateTabScreen(),
    PersonalScreen(),
  ];

  @override
  void initState() {
    super.initState();
    final viewModel = Get.put(HeaderHomeViewModel());
    viewModel.freshData();
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async => false,
      child: Scaffold(
        backgroundColor: Colors.transparent, // cho sáng nền tổng thể
        extendBody: true,
        body: _pages[_currentIndex],
        bottomNavigationBar: SafeArea(
          minimum: const EdgeInsets.only(left: 12, right: 12, bottom: 12),
          child: ClipRRect(
            borderRadius: BorderRadius.circular(132),
            child: Container(
              height: 72,
              color: BaseColor.primary500,
              padding: const EdgeInsets.symmetric(horizontal: 16),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  _buildTabItem(icon: Icons.home, label: 'Trang chủ', index: 0),
                  _buildTabItem(icon: Icons.confirmation_number_sharp, label: 'Ưu đãi', index: 1),
                  _buildTabItem(icon: null, label: 'Game', index: 2, gift: 'assets/images/ic_tabbar_game.gif'),
                  _buildTabItem(icon: Icons.shopping_cart, label: 'Mua sắm', index: 3),
                  _buildTabItem(icon: Icons.person, label: 'Cá nhân', index: 4),
                ],
              ),
            ),
          ),
        ),
      ),
    );
  }

  Widget _buildTabItem({required IconData? icon, required String label, required int index, String? gift}) {
    final isSelected = _currentIndex == index;
    return Expanded(
      child: GestureDetector(
        onTap: () => setState(() => _currentIndex = index),
        child: Container(
          color: Colors.transparent,
          alignment: Alignment.center,
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              if (icon != null)
                Icon(icon,
                  size: 28,
                  color: isSelected ? Colors.white : Colors.white70),
              if (gift != null)
                Image.asset(
                  gift,
                  width: 40,
                  height: 28,
                  fit: BoxFit.cover,
                  color: isSelected ? Colors.white : Colors.white70,
                ),
              const SizedBox(height: 2),
              Text(
                label,
                maxLines: 1,
                style: TextStyle(
                  color: isSelected ? Colors.white : Colors.white70,
                  fontWeight: isSelected ? FontWeight.bold : FontWeight.normal,
                  fontSize: 12,
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }
}
