import 'package:json_annotation/json_annotation.dart';
import 'package:mypoint_flutter_app/screen/home/models/image_model.dart';

import 'accumulated_counter_model.dart';
import 'membership_level_term_and_condition_model.dart';

part 'membership_level_model.g.dart';

@JsonSerializable()
class MembershipLevelModel {
  final String? id;

  @JsonKey(name: 'membership_level_rank')
  final String? rank;

  @JsonKey(name: 'membership_level_name')
  final String? levelName;

  @JsonKey(name: 'membership_level_description')
  final String? description;

  @JsonKey(name: 'membership_level_content')
  final String? content;

  @JsonKey(name: 'level_text_color')
  final String? levelTextColor;

  @JsonKey(name: 'logo')
  final String? logo;

  @JsonKey(name: 'level_start_at_date')
  final String? levelStartAtDate;

  @JsonKey(name: 'level_end_at_date')
  final String? levelEndAtDate;

  @JsonKey(name: 'refresh_level_after_months_from_start_date')
  final String? refreshAfterMonths;

  @JsonKey(name: 'upgrade_when_counter_is_greater_or_equal')
  final String? upgradePointThreshold;

  @JsonKey(name: 'upgrade_when_counter_gmv_is_greater_or_equal')
  final String? upgradeGmvThreshold;

  @JsonKey(name: 'downgrade_level_when_counter_is_less_than')
  final String? downgradePointThreshold;

  // @JsonKey(name: 'downgrade_level_when_counter_gmv_is_less_than')
  // final String? downgradeGmvThreshold;

  @JsonKey(name: 'upgrade_to_membership_level_id')
  final String? upgradeToLevelId;

  @JsonKey(name: 'membership_level_term_and_condition')
  final String? condition;

  @JsonKey(name: 'downgrade_to_membership_level_id')
  final String? downgradeToLevelId;

  @JsonKey(name: 'membership_level_term_and_conditions')
  final List<MembershipLevelTermAndConditionModel>? conditions;

  @JsonKey(name: 'accumulated_counter')
  final AccumulatedCounter? accumulatedCounter;

  final List<ImageModel>? images;

  MembershipLevelModel({
    this.id,
    this.rank,
    this.levelName,
    this.description,
    this.content,
    this.levelTextColor,
    this.logo,
    this.levelStartAtDate,
    this.levelEndAtDate,
    this.refreshAfterMonths,
    this.upgradePointThreshold,
    this.upgradeGmvThreshold,
    this.downgradePointThreshold,
    // this.downgradeGmvThreshold,
    this.condition,
    this.upgradeToLevelId,
    this.downgradeToLevelId,
    this.conditions,
    this.accumulatedCounter,
    this.images,
  });

  factory MembershipLevelModel.fromJson(Map<String, dynamic> json) =>
      _$MembershipLevelModelFromJson(json);

  Map<String, dynamic> toJson() => _$MembershipLevelModelToJson(this);
}