import 'package:get/get_rx/src/rx_types/rx_types.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../configs/constants.dart';
import '../../networking/restful_api_viewmodel.dart';
import 'models/notification_detail_model.dart';

class NotificationDetailViewModel extends RestfulApiViewModel {
  var notification = Rxn<NotificationDetailModel>();
  void Function(String message)? onShowAlertError;

  Future<void> fetchNotificationDetail({String? id, NotificationDetailModel? data}) async {
    if (data != null) {
      notification.value = data;
      return;
    }
    if (id == null) return;
    await callApi<NotificationDetailResponseModel>(
      request: () => client.getNotificationDetail(id ?? ''),
      onSuccess: (data, _) {
        final notify = data.notification;
        if (notify != null) {
          notification.value = data.notification;
        } else {
          onShowAlertError?.call(Constants.commonError);
        }
      },
      onFailure: (msg, _, _) async {
        onShowAlertError?.call(msg);
      },
    );
  }
}