import 'package:get/get.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import 'package:mypoint_flutter_app/shared/router_gage.dart';
import '../../base/base_response_model.dart';
import '../../networking/restful_api_viewmodel.dart';
import '../../configs/constants.dart';
import '../../preference/data_preference.dart';
import '../../widgets/custom_toast_message.dart';
import 'otp_viewmodel.dart';

class DeleteAccountOtpRepository extends RestfulApiViewModel implements IOtpRepository {
  DeleteAccountOtpRepository(this.phoneNumber, this.otpTtl);

  @override
  int otpTtl;
  @override
  String phoneNumber;

  @override
  Future<void> sendOtp() async {}

  @override
  Future<BaseResponseModel<EmptyCodable>> verifyOtp(String otpCode) async {
    showLoading();
    try {
      final value = await client.verifyDeleteAccount(otpCode);
      if (value.isSuccess) {
        await DataPreference.instance.clearBioToken(phoneNumber);
        await DataPreference.instance.clearData();
        Get.offAllNamed(onboardingScreen);
        showToastMessage("Xóa tài khoản thành công");
      }
      return value;
    } finally {
      hideLoading();
    }
  }

  @override
  Future<int?> resendOtp() async {
    showLoading();
    try {
      final value = await client.requestOtpDeleteAccount();
      if (value.isSuccess) {
        otpTtl = value.data?.resendAfterSecond ?? Constants.otpTtl;
        return otpTtl;
      }
      final mgs = value.errorMessage ?? Constants.commonError;
      Get.snackbar("Thông báo", mgs);
      return null;
    } finally {
      hideLoading();
    }
  }
}
