import 'package:get/get.dart';
import 'package:json_annotation/json_annotation.dart';

enum MediaTypeItemCampaign {
  image,
  imageLink,
  pageLink,
  text,
}

extension MediaTypeItemCampaignExtension on MediaTypeItemCampaign {
  String get key {
    switch (this) {
      case MediaTypeItemCampaign.image:
        return "image";
      case MediaTypeItemCampaign.imageLink:
        return "image_link";
      case MediaTypeItemCampaign.pageLink:
        return "page_link";
      case MediaTypeItemCampaign.text:
        return "text";
    }
  }
}