import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/screen/pipi/pipi_detail_viewmodel.dart';
import 'package:mypoint_flutter_app/widgets/image_loader.dart';
import '../home/models/pipi_detail_model.dart';

class PipiDetailScreen extends StatefulWidget {
  const PipiDetailScreen({super.key});

  @override
  State<PipiDetailScreen> createState() => _PipiDetailScreenState();
}

class _PipiDetailScreenState extends State<PipiDetailScreen> {
  final PipiDetailViewModel _viewModel = Get.put(PipiDetailViewModel());

  @override
  Widget build(BuildContext context) {
    return Obx(() {
      return Container(
        decoration: const BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.vertical(top: Radius.circular(24)),
        ),
        padding: const EdgeInsets.fromLTRB(16, 20, 16, 24),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          children: [
            Row(
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                const Spacer(),
                const Expanded(
                  flex: 6,
                  child: Text(
                    'Liên hệ',
                    textAlign: TextAlign.center,
                    style: TextStyle(
                      fontSize: 18,
                      fontWeight: FontWeight.bold,
                      color: Colors.black87,
                    ),
                  ),
                ),
                Expanded(
                  child: IconButton(
                    icon: const Icon(Icons.close),
                    onPressed: () => Navigator.of(context).pop(),
                  ),
                )
              ],
            ),
            const SizedBox(height: 12),
            ..._viewModel.items.map((item) => _buildItem(context, item)),
            const SizedBox(height: 100),
          ],
        ),
      );
    });
  }

  Widget _buildItem(BuildContext context, PipiSupportItemModel item) {
    return InkWell(
      onTap: () {
        Navigator.of(context).pop();
        item.directionScreen?.begin();
      },
      child: Container(
        margin: const EdgeInsets.only(bottom: 12),
        padding: const EdgeInsets.symmetric(horizontal: 12, vertical: 14),
        decoration: BoxDecoration(
          color: const Color(0xFFF8F8F8),
          borderRadius: BorderRadius.circular(16),
        ),
        child: Row(
          children: [
            ClipRRect(
              borderRadius: BorderRadius.circular(24),
              child: loadNetworkImage(
                url: item.icon ?? '',
                width: 36,
                height: 36,
              )
            ),
            const SizedBox(width: 12),
            Text(item.title ?? '', style: const TextStyle(fontSize: 16)),
          ],
        ),
      ),
    );
  }
}
