import 'package:flutter/material.dart';

import '../../configs/callbacks.dart';
import '../../widgets/back_button.dart';

class QuizCampaignHeader extends StatelessWidget {
  final int currentIndex;
  final int total;
  final VoidCallback? onBackPressed;

  const QuizCampaignHeader({
    super.key,
    required this.currentIndex,
    required this.total,
    this.onBackPressed,
  });

  @override
  Widget build(BuildContext context) {
    final topSpace = MediaQuery.of(context).padding.top;
    return Stack(
      children: [
        Container(
          padding: EdgeInsets.only(top: topSpace, left: 16, right: 16),
          color: const Color(0xFFFFF1F3),
          child: Column(
            children: [
              Row(
                children: [
                  CustomBackButton(
                    onPressed: onBackPressed ?? () => Navigator.of(context).pop(),
                  ),
                  const SizedBox(width: 12),
                  Expanded(child: _buildProgressBar(currentIndex, total)),
                  const SizedBox(width: 24),
                ],
              ),
              Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  Expanded(
                    child: const Text(
                      'Khảo sát\nnhận thưởng',
                      style: TextStyle(
                        fontSize: 24,
                        fontWeight: FontWeight.w800,
                        color: Color(0xFF3B0E0E),
                      ),
                    ),
                  ),
                  const SizedBox(width: 12),
                  Image.asset(
                    'assets/images/ic_header_quiz_survey.png',
                    height: 180,
                    fit: BoxFit.contain,
                  ),
                ],
              ),
            ],
          ),
        ),
      ],
    );
  }

  Widget _buildProgressBar(int current, int total) {
    return Row(
      children: List.generate(
        total,
            (index) => Expanded(
          child: Container(
            height: 6,
            margin: EdgeInsets.only(left: index == 0 ? 0 : 8),
            decoration: BoxDecoration(
              color: index <= current ? const Color(0xFFEC4A53) : Colors.white,
              borderRadius: BorderRadius.circular(3),
            ),
          ),
        ),
      ),
    );
  }
}
