import '../../widgets/alert/popup_data_model.dart';

enum SurveyQuestionType {
  textarea,
  radio,
  checkbox;

  String get textDes {
    switch (this) {
      case SurveyQuestionType.textarea:
        return 'Nhập câu trả lời dạng text';
      case SurveyQuestionType.radio:
        return 'Chọn 1 đáp án duy nhất';
      case SurveyQuestionType.checkbox:
        return 'Chọn nhiều đáp án';
    }
  }
}

SurveyQuestionType? _parseType(String? raw) {
  if (raw == null) return null;
  return SurveyQuestionType.values.firstWhere(
        (e) => e.name == raw,
    orElse: () => SurveyQuestionType.textarea,
  );
}

class QuizCampaignSubmitResponseModel {
  final PopupDataModel? popup;
  QuizCampaignSubmitResponseModel({this.popup});

  factory QuizCampaignSubmitResponseModel.fromJson(Map<String, dynamic> json) {
    return QuizCampaignSubmitResponseModel(
      popup: json['popup'] != null ? PopupDataModel.fromJson(json['popup']) : null,
    );
  }

  Map<String, dynamic> toJson() {
    return {
      'popup': popup?.toJson(),
    };
  }
}

class SurveyAnswerCampaignModel {
  int? id;
  String? value;
  String? placeholder;
  String? type;
  bool? isSelected;
  bool? required;

  SurveyQuestionType? get qType {
    return _parseType(type);
  }

  SurveyAnswerCampaignModel();

  factory SurveyAnswerCampaignModel.fromJson(Map<String, dynamic> json) {
    return SurveyAnswerCampaignModel()
      ..id = json['id']
      ..value = json['value']
      ..placeholder = json['placeholder']
      ..type = json['type']
      ..isSelected = json['isSelected']
      ..required = json['required'];
  }

  Map<String, dynamic> toJson() => {
    'id': id,
    'value': value,
    'placeholder': placeholder,
    'type': type,
    'isSelected': isSelected,
    'required': required,
  };
}

class SurveyQuestionCampaignModel {
  int id;
  bool? required;
  String? type;
  String? text;
  List<SurveyAnswerCampaignModel>? choices;
  String? textDesIndex;
  String? inputText;

  SurveyQuestionCampaignModel({
    required this.id,
    this.required,
    this.type,
    this.text,
    this.choices,
    this.textDesIndex,
    this.inputText,
  });

  bool get answered {
    if (qType == SurveyQuestionType.textarea) {
      return inputText?.isNotEmpty ?? false;
    } else if (qType == SurveyQuestionType.radio || qType == SurveyQuestionType.checkbox) {
      return choices?.any((e) => e.isSelected == true) ?? false;
    }
    return false;
  }

  SurveyQuestionType? get qType => _parseType(type);

  Map<String, dynamic> get submitParamQuestion {
    final List<dynamic> answers = [];
    if (qType == SurveyQuestionType.textarea) {
      answers.add({'text': inputText ?? ''});
    } else {
      for (var item in choices ?? []) {
        answers.add({'text': item.value ?? ''});
      }
    }
    return {
      'question_id': id,
      'answers': answers,
    };
  }

  factory SurveyQuestionCampaignModel.fromJson(Map<String, dynamic> json) {
    return SurveyQuestionCampaignModel(
      id: json['id'],
      required: json['required'],
      type: json['type'],
      text: json['text'],
      choices: (json['choices'] as List?)
          ?.map((e) => SurveyAnswerCampaignModel.fromJson(e))
          .toList(),
      inputText: json['input_text'],
    );
  }
}

class SurveyCampaignInfoModel {
  int id;
  String? name;
  List<SurveyQuestionCampaignModel>? questions;

  SurveyCampaignInfoModel({
    required this.id,
    this.name,
    this.questions,
  });

  void makeQuestionsTextDesIndex() {
    final total = questions?.length ?? 0;
    for (var i = 0; i < total; i++) {
      final q = questions![i];
      final des = 'Câu ${i + 1}/$total: ${q.qType?.textDes ?? ''}';
      q.textDesIndex = des;

      if (q.qType == SurveyQuestionType.textarea && (q.choices?.isEmpty ?? true)) {
        q.choices = [SurveyAnswerCampaignModel()];
      }
    }
  }

  Map<String, dynamic> get submitParam {
    return {
      'quiz_id': id,
      'answers': questions?.map((e) => e.submitParamQuestion).toList() ?? [],
    };
  }

  factory SurveyCampaignInfoModel.fromJson(Map<String, dynamic> json) {
    return SurveyCampaignInfoModel(
      id: json['id'],
      name: json['name'],
      questions: (json['questions'] as List?)
          ?.map((e) => SurveyQuestionCampaignModel.fromJson(e))
          .toList(),
    );
  }
}
