import 'package:json_annotation/json_annotation.dart';
import 'package:mypoint_flutter_app/directional/directional_screen.dart';

part 'form_input_description_model.g.dart';
@JsonSerializable()
class FormInputDescriptionModel {
  final String? title;
  final bool? checkbox;
  @JsonKey(name: 'click_action_type')
  final String? clickActionType;
  @JsonKey(name: 'click_action_param')
  final String? clickActionParam;

  DirectionalScreen? get directional {
    return DirectionalScreen.build(
      clickActionType: clickActionType,
      clickActionParam: clickActionParam,
    );
  }

  FormInputDescriptionModel({
    this.title,
    this.checkbox,
    this.clickActionType,
    this.clickActionParam,
  });

  factory FormInputDescriptionModel.fromJson(Map<String, dynamic> json) =>
      _$FormInputDescriptionModelFromJson(json);

  Map<String, dynamic> toJson() => _$FormInputDescriptionModelToJson(this);
}

