import 'package:json_annotation/json_annotation.dart';

part 'verify_register_model.g.dart';
@JsonSerializable()
class VerifyRegisteredPackageModel {
  final bool? registed;
  @JsonKey(name: 'create_time')
  final String? createTime;
  @JsonKey(name: 'expire_time')
  final String? expireTime;
  final String? description;

  const VerifyRegisteredPackageModel({
    this.registed,
    this.createTime,
    this.expireTime,
    this.description,
  });

  factory VerifyRegisteredPackageModel.fromJson(Map<String, dynamic> json)
  => _$VerifyRegisteredPackageModelFromJson(json);
  Map<String, dynamic> toJson() => _$VerifyRegisteredPackageModelToJson(this);
}

@JsonSerializable(explicitToJson: true)
class VerifyRegisterCampaignAlertModel {
  final bool? alert;
  final String? description;

  const VerifyRegisterCampaignAlertModel({this.alert, this.description});

  factory VerifyRegisterCampaignAlertModel.fromJson(Map<String, dynamic> json)
  => _$VerifyRegisterCampaignAlertModelFromJson(json);
  Map<String, dynamic> toJson() => _$VerifyRegisterCampaignAlertModelToJson(this);
}

@JsonSerializable(explicitToJson: true)
class VerifyRegisterCampaignModel {
  final bool? valid;
  @JsonKey(name: 'full_name')
  final String? fullName;
  @JsonKey(name: 'phone_number')
  final String? phoneNumber;
  @JsonKey(name: 'license_plate')
  final String? licensePlate;
  @JsonKey(name: 'registed_package')
  final VerifyRegisteredPackageModel? registeredPackage;
  final VerifyRegisterCampaignAlertModel? alert;

  const VerifyRegisterCampaignModel({
    this.valid,
    this.fullName,
    this.phoneNumber,
    this.licensePlate,
    this.registeredPackage,
    this.alert,
  });

  factory VerifyRegisterCampaignModel.fromJson(Map<String, dynamic> json)
  => _$VerifyRegisterCampaignModelFromJson(json);
  Map<String, dynamic> toJson() => _$VerifyRegisterCampaignModelToJson(this);
}

class VerifyFormRegisterModel {
  final String? url;
  const VerifyFormRegisterModel({this.url});

  factory VerifyFormRegisterModel.fromJson(Map<String, dynamic> json) {
    return VerifyFormRegisterModel(
      url: json['url'] as String?,
    );
  }

  Map<String, dynamic> toJson() => {
    'url': url,
  };
}