import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../shared/router_gage.dart';
import '../../../widgets/custom_empty_widget.dart';
import '../../../widgets/custom_navigation_bar.dart';
import '../../../widgets/image_loader.dart';
import '../../home/models/my_product_model.dart';
import 'my_product_list_viewmodel.dart';
import 'package:dotted_border/dotted_border.dart';

class MyVoucherListScreen extends StatefulWidget {
  const MyVoucherListScreen({super.key});

  @override
  State<MyVoucherListScreen> createState() => _MyVoucherListScreenState();
}

class _MyVoucherListScreenState extends State<MyVoucherListScreen> {
  late final MyProductListViewModel _viewModel;

  @override
  void initState() {
    super.initState();
    _viewModel = Get.put(MyProductListViewModel());
  }

  @override
  Widget build(BuildContext context) {
    final screenWidth = MediaQuery.of(context).size.width;
    return Scaffold(
      appBar: CustomNavigationBar(title: 'Ưu đãi của tôi'),
      body: Obx(
        () => Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Padding(
              padding: const EdgeInsets.all(8.0),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceAround,
                children: [_buildTab('Đang có', 0), _buildTab('Đã sử dụng', 1), _buildTab('Hết hạn', 2)],
              ),
            ),
            const Divider(height: 1),
            if (_viewModel.myProducts.isEmpty)
              Expanded(child: EmptyWidget(size: Size(screenWidth / 2, screenWidth / 2)))
            else
              Expanded(
                child: RefreshIndicator(
                  onRefresh: () async {
                    _viewModel.freshData(isRefresh: true);
                  },
                  child: ListView.builder(
                    padding: const EdgeInsets.all(12),
                    itemCount: _viewModel.myProducts.length,
                    itemBuilder: (_, index) {
                      if (index >= _viewModel.myProducts.length) {
                        _viewModel.freshData(isRefresh: false);
                        return const Center(
                          child: Padding(padding: EdgeInsets.all(16), child: CircularProgressIndicator()),
                        );
                      }
                      final product = _viewModel.myProducts[index];
                      return _buildVoucherItem(product);
                    },
                  ),
                ),
              ),
          ],
        ),
      ),
    );
  }

  Widget _buildTab(String title, int index) {
    return GestureDetector(
      onTap: () => _viewModel.selectTab(index),
      child: Obx(
        () => Column(
          children: [
            Text(
              title,
              style: TextStyle(
                fontSize: 16,
                fontWeight: FontWeight.w600,
                color: _viewModel.selectedTabIndex.value == index ? Colors.red : Colors.black54,
              ),
            ),
            const SizedBox(height: 4),
            if (_viewModel.selectedTabIndex.value == index) Container(height: 2, width: 60, color: Colors.red),
          ],
        ),
      ),
    );
  }

  Widget _buildVoucherItem(MyProductModel product) {
    return GestureDetector(
      onTap: () {
        Get.toNamed(voucherDetailScreen, arguments: {"customerProductId": product.id});
      },
      child: Container(
        margin: const EdgeInsets.symmetric(vertical: 8),
        padding: const EdgeInsets.all(0),
        child: DottedBorder(
          options: RoundedRectDottedBorderOptions(
            color: Colors.redAccent.withOpacity(0.3),
            radius: const Radius.circular(12),
            dashPattern: const [3, 3],
            strokeWidth: 1,
          ),
          // color: Colors.redAccent.withOpacity(0.3),
          // borderType: BorderType.RRect,
          // radius: const Radius.circular(12),
          // dashPattern: const [3, 3],
          // strokeWidth: 1,
          child: Container(
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(12),
              color: Colors.redAccent.withOpacity(0.03),
            ),
            padding: const EdgeInsets.all(12),
            child: Row(
              children: [
                ClipRRect(
                  borderRadius: BorderRadius.circular(8),
                  child: loadNetworkImage(
                    url: product.logo ?? '',
                    width: 64,
                    height: 64,
                    fit: BoxFit.cover,
                    placeholderAsset: "assets/images/bg_default_11.png",
                  ),
                ),
                const SizedBox(width: 16),
                Expanded(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text(
                        product.brandName ?? '',
                        style: const TextStyle(fontWeight: FontWeight.bold, color: Colors.black54, fontSize: 12),
                      ),
                      const SizedBox(height: 6),
                      Text(product.title ?? '', style: const TextStyle(fontSize: 15, fontWeight: FontWeight.w500)),
                      const SizedBox(height: 6),
                      Text('HSD: ${product.expire}', style: const TextStyle(color: Colors.black54, fontSize: 12)),
                    ],
                  ),
                ),
              ],
            ),
          ),
        ),
      ),
    );
  }
}
