# @microsoft/api-extractor-model

Use this library to read and write *.api.json files as defined by the [API Extractor](https://api-extractor.com/) tool.
These files are used to generate a documentation website for your TypeScript package.  The files store the
API signatures and doc comments that were extracted from your package.

API documentation for this package: https://api.rushstack.io/pages/api-extractor-model/

## Example Usage

The following code sample shows how to load `example.api.json`, which would be generated by API Extractor
when it analyzes a hypothetical NPM package called `example`:

```ts
import { ApiModel, ApiPackage } from '@microsoft/api-extractor-model';

const apiModel: ApiModel = new ApiModel();
const apiPackage: ApiPackage = apiModel.loadPackage('example.api.json');

for (const member of apiPackage.members) {
  console.log(member.displayName);
}
```

The `ApiModel` is acts as a container for various packages that are loaded and operated on as a group.
For example, a documentation tool may need to resolve `@link` references across different packages.
In this case we would load the various packages into the `ApiModel`, and then use
the `ApiModel.resolveDeclarationReference()` to resolve the `@link` targets.

The data structure forms a tree of various classes that start with the `Api` prefix.  The nesting hierarchy
might look like this:

```
- ApiModel
  - ApiPackage
    - ApiEntryPoint
      - ApiClass
        - ApiMethod
        - ApiProperty
      - ApiEnum
        - ApiEnumMember
      - ApiInterface
        - ApiMethodSignature
        - ApiPropertySignature
      - ApiNamespace
        - (ApiClass, ApiEnum, ApiInterface, ...)
```

You can use the `ApiItem.members` property to traverse this tree.

Note that the non-abstract classes (e.g. `ApiClass`, `ApiEnum`, `ApiInterface`, etc.) use
TypeScript "mixin" functions (e.g. `ApiDeclaredItem`, `ApiItemContainerMixin`, etc.) to add various
features that cannot be represented as a normal inheritance chain (since TypeScript does not allow a child class
to extend more than one base class).  The "mixin" is a TypeScript merged declaration with three components:
the function that generates a subclass, an interface that describes the members of the subclass, and
a namespace containing static members of the class.

> For a complete project that uses these APIs to generate an API reference web site,
> see the [@microsoft/api-documenter](https://www.npmjs.com/package/@microsoft/api-documenter) source code.

## Links

- [CHANGELOG.md](
  https://github.com/microsoft/rushstack/blob/main/libraries/api-extractor-model/CHANGELOG.md) - Find
  out what's new in the latest version
- [API Reference](https://api.rushstack.io/pages/api-extractor-model/)

API Extractor is part of the [Rush Stack](https://rushstack.io/) family of projects.
