"use strict";
// Copyright (c) Microsoft Corporation. All rights reserved. Licensed under the MIT license.
// See LICENSE in the project root for license information.
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConsoleMessageId = void 0;
/**
 * Unique identifiers for console messages reported by API Extractor.
 *
 * @remarks
 *
 * These strings are possible values for the {@link ExtractorMessage.messageId} property
 * when the `ExtractorMessage.category` is {@link ExtractorMessageCategory.Console}.
 *
 * @public
 */
var ConsoleMessageId;
(function (ConsoleMessageId) {
    /**
     * "Analysis will use the bundled TypeScript version ___"
     */
    ConsoleMessageId["Preamble"] = "console-preamble";
    /**
     * "The target project appears to use TypeScript ___ which is newer than the bundled compiler engine;
     * consider upgrading API Extractor."
     */
    ConsoleMessageId["CompilerVersionNotice"] = "console-compiler-version-notice";
    /**
     * "Using custom TSDoc config from ___"
     */
    ConsoleMessageId["UsingCustomTSDocConfig"] = "console-using-custom-tsdoc-config";
    /**
     * "Found metadata in ___"
     */
    ConsoleMessageId["FoundTSDocMetadata"] = "console-found-tsdoc-metadata";
    /**
     * "Writing: ___"
     */
    ConsoleMessageId["WritingDocModelFile"] = "console-writing-doc-model-file";
    /**
     * "Writing package typings: ___"
     */
    ConsoleMessageId["WritingDtsRollup"] = "console-writing-dts-rollup";
    /**
     * "Generating ___ API report: ___"
     */
    ConsoleMessageId["WritingApiReport"] = "console-writing-api-report";
    /**
     * "You have changed the public API signature for this project.
     * Please copy the file ___ to ___, or perform a local build (which does this automatically).
     * See the Git repo documentation for more info."
     *
     * OR
     *
     * "The API report file is missing.
     * Please copy the file ___ to ___, or perform a local build (which does this automatically).
     * See the Git repo documentation for more info."
     */
    ConsoleMessageId["ApiReportNotCopied"] = "console-api-report-not-copied";
    /**
     * "You have changed the public API signature for this project.  Updating ___"
     */
    ConsoleMessageId["ApiReportCopied"] = "console-api-report-copied";
    /**
     * "The API report is up to date: ___"
     */
    ConsoleMessageId["ApiReportUnchanged"] = "console-api-report-unchanged";
    /**
     * "The API report file was missing, so a new file was created. Please add this file to Git: ___"
     */
    ConsoleMessageId["ApiReportCreated"] = "console-api-report-created";
    /**
     * "Unable to create the API report file. Please make sure the target folder exists: ___"
     */
    ConsoleMessageId["ApiReportFolderMissing"] = "console-api-report-folder-missing";
    /**
     * Used for the information printed when the "--diagnostics" flag is enabled.
     */
    ConsoleMessageId["Diagnostics"] = "console-diagnostics";
})(ConsoleMessageId || (exports.ConsoleMessageId = ConsoleMessageId = {}));
//# sourceMappingURL=ConsoleMessageId.js.map