#!/bin/bash

# Script để chuyển đổi giữa môi trường dev và production

ENV=${1:-"prod"}

if [ "$ENV" = "dev" ]; then
    echo "🔧 Switching to DEVELOPMENT environment..."
    cp assets/config/env_dev.json assets/config/env.json
    echo "✅ Switched to DEVELOPMENT:"
    echo "   - API: https://api.sandbox.mypoint.com.vn/8854/gup2start/rest"
    echo "   - Logging: Enabled"
    echo "   - Flavor: dev"
elif [ "$ENV" = "prod" ]; then
    echo "🚀 Switching to PRODUCTION environment..."
    # Create production config directly
    cat > assets/config/env.json << 'EOF'
{
  "flavor":"pro",
  "baseUrl":"https://api.mypoint.com.vn/8854/gup2start/rest",
  "t3Token":"runner-env-flavor-pro",
  "enableLogging":false
}
EOF
    echo "✅ Switched to PRODUCTION:"
    echo "   - API: https://api.mypoint.com.vn/8854/gup2start/rest"
    echo "   - Logging: Disabled"
    echo "   - Flavor: pro"
else
    echo "❌ Invalid environment. Use 'dev' or 'prod'"
    echo "Usage: ./scripts/switch_env.sh [dev|prod]"
    exit 1
fi

echo ""
echo "📋 Current config:"
cat assets/config/env.json
echo ""
echo "💡 Now you can run:"
echo "   - Development: ./scripts/run_web_complete.sh"
echo "   - Export: ./export_web.sh"

